<?php

namespace App\Http\Controllers;

use App\Models\BemMaterial;
use App\Models\TipoBemMaterial;
use App\Models\FormaAquisicaoBem;
use App\Models\DepreciacaoBemMaterial;
use App\Models\Membro;
use App\Models\Igreja;
use DB;
use App\Http\Requests\StoreBemMaterialRequest;
use App\Http\Requests\UpdateBemMaterialRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class BemMaterialController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $bensmateriais = BemMaterial::latest()->paginate(150);
        $tiposbensmateriais = TipoBemMaterial::all();
        $formasaquisicaobens = FormaAquisicaoBem::all();
        $membros = Membro::all();

        return view('bemMaterial.index',compact('bensmateriais','tiposbensmateriais','formasaquisicaobens','membros'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         //die($eventos );
        $bensmateriais = BemMaterial::all();
        $tiposbensmateriais = TipoBemMaterial::all();
        $formasaquisicaobens = FormaAquisicaoBem::all();
        $membros = Membro::all();
        $igrejas = Igreja::all();

        return view('bemMaterial.create',['bensmateriais' => $bensmateriais, 'tiposbensmateriais' => $tiposbensmateriais, 'formasaquisicaobens' => $formasaquisicaobens,'membros' => $membros,'igrejas' => $igrejas]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBemMaterialRequest $request)
    {


        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') ) {

            DB::beginTransaction();

            //movimentando a caixa
            //$caixas = DB::table('caixas')->where('status', '=', 1)->get();
           // $saldoAnterior = $caixa['saldoActual'];

        //   foreach ($caixas as $caixa) {
                        //dd($caixa->saldoActual);

        //    if($caixa != null){
        //        $saldoAnt = $caixa->saldoActual;
        //        $saldoActual = ($caixa->saldoActual + $request->valor);

        //    }
        //    DB::table('caixas')->where('status', '=', 1)->update(['saldoAnt'=>$saldoAnt,'saldoActual'=>$saldoActual]);

        //}
            BemMaterial::create(
            ['valor' => $request->valor,
            'referencia'   =>  $request->referencia,
            'nome'   =>  $request->nome,
            'data'   => $request->data,
            'tipos_bens_materiais_id'   => $request->tipos_bens_materiais_id,
            'formas_aquisicao_bens_id'   => $request->formas_aquisicao_bens_id,
            'membros_id'   => $request->membros_id,
            'igrejas_id'   => $request->igrejas_id
            ]);

            //Entranda::create($request->all(),$qtd_total_part);
            DB::commit();
            return redirect()->route('bensmateriais.index')
            ->with('mensagem','Bem Matrial registado com sucesso');
                                            }
            else{
                DB::rollBack();

                DB::beginTransaction(false);
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\BemMaterial  $bemmaterial
     * @return \Illuminate\Http\Response
     */
    public function show(Request  $request,$id)
    {
        //dd($evento);

        $ID = decrypt($id);
        $bemmaterial = BemMaterial::findOrFail($ID);

        $tiposbensmateriais = TipoBemMaterial::all();
        $formasaquisicaobens = FormaAquisicaoBem::all();
        //$caixas = Caixa::all();
        $membros = Membro::all();
        return view('bemMaterial.show',compact('bemmaterial','tiposbensmateriais','formasaquisicaobens'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\BemMaterial $bemmaterial
     * @return \Illuminate\Http\Response
     */
    public function edit(Request  $request,$id)
    {

        $ID = decrypt($id);
        $bemmaterial = BemMaterial::findOrFail($ID);

        $tiposbensmateriais = TipoBemMaterial::all();
        $formasaquisicaobens = FormaAquisicaoBem::all();
        //$caixas = Caixa::all();
        $membros = Membro::all();

        return view('bemMaterial.create',['bemmaterial' => $bemmaterial, 'tiposbensmateriais' => $tiposbensmateriais, 'formasaquisicaobens' => $formasaquisicaobens,'membros' => $membros]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\BemMaterial  $bemmaterial
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBemMaterialRequest $request, $id)
    {

        $ID = decrypt($id);
        $bemmaterial = BemMaterial::findOrFail($ID);
        //die($request->all());
        if (Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {
            $bemmaterial->update($request->all());

            return redirect()->route('bensmateriais.index')
                            ->with('mensagem','Bem Matrial actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\BemMatrial  $bemmaterial
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {
        $ID = decrypt($id);
        $bemmaterial = BemMaterial::findOrFail($ID);
        if (Gate::allows('isSuperadmin')) {
            $bemmaterial->delete();

            return redirect()->route('bensmateriais.index')
                            ->with('mensagem','Bem Matrial eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }


     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoAjax()
    {

            $array = array();

            $bensmateriais = BemMaterial::all();

            foreach ($bensmateriais as $bemmaterial) {

               // $user = $bemmaterial->user;
                $tmp_array = array(
                    'id' => $bemmaterial->id,

                    'tipo_bem_material' => $bemmaterial->tipos_bens_materiais->nome,
                    'membro' => $bemmaterial->membro->nome,
                    'forma_aquisicao_bem' => $bemmaterial->formas_aquisicao_bens->nome,
                    'referencia' => $bemmaterial->descricao,
                    'valor' => $bemmaterial->valor,
                    'data' => $bemmaterial->data,



                );

                array_push($array, $tmp_array);
            }

            return json_encode($array);

    }

    public function exploracao()
    {
        $bemMaterial = BemMaterial::orderBy('id', 'asc')->get();
        return view('bemMaterial.exploracao',compact('bemMaterial'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function deprecicao(Request  $request)
    {


        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') || Gate::allows('isFinanceiro') ) {

            DB::beginTransaction();

            //movimentando a caixa
            $bens_materiais = DB::table('bens_materiais')->get();
           // $saldoAnterior = $caixa['saldoActual'];

           foreach ($bens_materiais as $bemMaterial) {
                        //dd($caixa->saldoActual);


                //Validar se o Bem esta activo
                //$result=$bemMaterial->estado !== 'D';
                //dd($result);
                if($bemMaterial->estado !== 'D'){

                    DB::rollBack();

                    DB::beginTransaction(false);
                      return view('errors.messageDepreciacao');
                }else{
                    //Actualizando o saldo actual após a saida ter todas condições
                    $bem_selelecionado =  $request->bens_materiais_id;
                    DB::table('bens_materiais')->where('id', '=', $bem_selelecionado)->update(['estado'=>'D']);

                    DepreciacaoBemMaterial::create(
                    ['motivo' => $request->motivo,
                    'estado'   =>  'D',
                    'data_depreciacao'   => $request->data_depreciacao,
                    'bens_materiais_id'   => $request->bens_materiais_id
                    ]);


            DB::commit();
            return redirect()->route('bensmateriais.index')
            ->with('mensagem','Bem Depreciado com sucesso');
        }






}                                }
            else{
                DB::rollBack();

                DB::beginTransaction(false);
                  return view('errors.message');
                }
    }




}
