<?php

namespace App\Http\Controllers;

use App\Models\Entrada;
use App\Models\TipoEntrada;
use App\Models\FormaPagamento;
use App\Models\Caixa;
use App\Models\Membro;
use DB;
use App\Http\Requests\StoreEntradaRequest;
use App\Http\Requests\UpdateEntradaRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class EntradaController extends Controller
{
    //
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $entradas = Entrada::latest()->paginate(150);
        $tiposentradas = TipoEntrada::all();
        $formaspagamentos = FormaPagamento::all();
        $membros = Membro::all();

        return view('entrada.index',compact('entradas','tiposentradas','formaspagamentos','membros'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($eventos );
        $entradas = Entrada::all();
        $tiposentradas = TipoEntrada::all();
        $formaspagamentos = FormaPagamento::all();
        $membros = Membro::all();
        $caixas = Caixa::all();

        return view('entrada.create',['entradas' => $entradas, 'tiposentradas' => $tiposentradas, 'formaspagamentos' => $formaspagamentos,'caixas' => $caixas,'membros' => $membros]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreEntradaRequest $request)
    {


        //dd($qtd_total_part);

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') ) {

            DB::beginTransaction();

            //movimentando a caixa
            $caixas = DB::table('caixas')->where('status', '=', 1)->get();
           // $saldoAnterior = $caixa['saldoActual'];

           foreach ($caixas as $caixa) {
                        //dd($caixa->saldoActual);

            if($caixa != null){
                $saldoAnt = $caixa->saldoActual;
                $saldoActual = ($caixa->saldoActual + $request->valor);

            }
            DB::table('caixas')->where('status', '=', 1)->update(['saldoAnt'=>$saldoAnt,'saldoActual'=>$saldoActual]);

        }
            Entrada::create(
            ['valor' => $request->valor,
            'descricao'   =>  $request->descricao,
            'data_entrada'   => $request->data_entrada,
            'tipos_entradas_id'   => $request->tipos_entradas_id,
            'formas_pagamentos_id'   => $request->formas_pagamentos_id,
            'membros_id'   => $request->membros_id
            ]);

            //Entranda::create($request->all(),$qtd_total_part);
            DB::commit();
            return redirect()->route('entradas.index')
            ->with('mensagem','Entrada registado com sucesso');
                                            }
            else{
                DB::rollBack();

                DB::beginTransaction(false);
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Entrada  $entrada
     * @return \Illuminate\Http\Response
     */
    public function show(Request  $request,$id)
    {
        //dd($evento);

        $ID = decrypt($id);
        $entrada = Entrada::findOrFail($ID);

        $tiposentradas = TipoEntrada::all();
        $formaspagamentos = FormaPagamento::all();
        $caixas = Caixa::all();
        $membros = Membro::all();
        return view('entrada.show',compact('entrada','tiposentradas','formaspagamentos','caixas','membros'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Entrada $entrada
     * @return \Illuminate\Http\Response
     */
    public function edit(Request  $request,$id)
    {

        $ID = decrypt($id);
        $entrada = Entrada::findOrFail($ID);

        $tiposentradas = TipoEntrada::all();
        $formaspagamentos = FormaPagamento::all();
        $caixas = Caixa::all();
        $membros = Membro::all();

        return view('entrada.create',['entrada' => $entrada, 'tiposentradas' => $tiposentradas, 'formaspagamentos' => $formaspagamentos,'caixas' => $caixas,'membros' => $membros]);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Entrada  $entrada
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateEntradaRequest $request, $id)
    {

        $ID = decrypt($id);
        $entrada = Entrada::findOrFail($ID);
        //die($request->all());
        if (Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {
            $entrada->update($request->all());

            return redirect()->route('entradas.index')
                            ->with('mensagem','Entrada actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Entrada  $evento
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {
        $ID = decrypt($id);
        $entrada = Entrada::findOrFail($ID);
        if (Gate::allows('isSuperadmin')) {
            $entrada->delete();

            return redirect()->route('entradas.index')
                            ->with('mensagem','Entrada eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }


     /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoAjax()
    {

            $array = array();

            $entradas = Entrada::all();

            foreach ($entradas as $entrada) {

               // $user = $entrada->user;
                $tmp_array = array(
                    'id' => $entrada->id,

                    'tipo_entrada' => $entrada->tipos_entradas->nome,
                    'membro' => $entrada->membros->nome,
                    'forma_pagamento' => $entrada->formas_pagamentos->nome,
                    'descricao' => $entrada->descricao,
                    'valor' => $entrada->valor,
                    'data_entrada' => $entrada->data_entrada,



                );

                array_push($array, $tmp_array);
            }

            return json_encode($array);

    }

    public function exploracao()
    {
        $membros = Membro::orderBy('id', 'asc')->get();
        return view('entrada.exploracao',compact('membros'));
    }



}
