<?php

namespace App\Http\Controllers;

use DB;
use App\Models\Membro;
use App\Models\Igreja;
use App\Models\Pais;
use App\Models\Provincia;
use App\Models\Municipio;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\StoreMembroRequest;
use App\Http\Requests\UpdateMembroRequest;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $data = Membro::latest()->paginate(150);

        return view('membro.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    public function getCountries()
    {
        $countries = DB::table('pais')
                ->get();

        return $countries;
    }

    public function getState(Request $request)
    {
        $data['provincias'] = Provincia::where("pais_id",$request->pais_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }
    public function getCity(Request $request)
    {
        $data['municipios'] = Municipio::where("provincia_id",$request->provincia_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function dashboard()
    {


        //die('verificar');
        $totalMembrosMasculino = DB::table('membros')
                                    ->where('genero', '=', 'M')
                                    ->count();
                                    //->get();

        $totalMembrosFemenino = DB::table('membros')
                                ->where('genero', '=', 'F')
                                ->count();

        $totalIgreja = DB::table('igrejas')
                                ->count();

        $totalCultos = DB::table('eventos')
                                ->where('tipos_eventos_id', '=', 1)
                                ->count();

        $totalEventos = DB::table('eventos')
                                ->count();

        $totalEventosTipoEvento = DB::select(DB::raw("Select tipos_eventos.nome, count(eventos.id) As qtd
                                                From eventos JOIN tipos_eventos ON
                                                tipos_eventos.id = eventos.tipos_eventos_id
                                                Group By tipos_eventos.nome"
                                                ));

        $membros = DB::select(DB::raw("SELECT * from membros where month(data_nascimento) = month(now())"
                                        ));


        $chartDataEvTip="";
        foreach($totalEventosTipoEvento as $list){
            $chartDataEvTip.="['".$list->nome."',      ".$list->qtd."],";
        }
        //$arr['chartDataEvTip']=rtrim($chartDataEvTip,",");
$chartData=$chartDataEvTip;
        //dd($totalMembrosMasculino);
        return view('dashboard',compact('totalMembrosMasculino','totalMembrosFemenino'
                                        ,'totalIgreja','totalCultos','totalEventos','chartData','membros'));

    }



}
