<?php

namespace App\Http\Controllers;

use App\Models\Igreja;
use App\Models\Pais;
use App\Models\Provincia;
use App\Models\Municipio;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\StoreIgrejaRequest;
use App\Http\Requests\UpdateIgrejaRequest;
use Illuminate\Http\Request;

class IgrejaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $data = Igreja::latest()->paginate(150);

        return view('igreja.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($igrejas );
        $igrejas = Igreja::all();
        $pais = Pais::all();

        return view('igreja.create',['igrejas' => $igrejas, 'pais' => $pais]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreIgrejaRequest $request)
    {
        //dd($request->all());

        if (Gate::allows('isGestor') || Gate::allows('isSuperadmin') ) {

            Igreja::create($request->all());

            return redirect()->route('igrejas.index')
            ->with('mensagem','Igreja registado com sucesso');
                                            }
            else{
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Igreja  $igreja
     * @return \Illuminate\Http\Response
     */
    public function show(Igreja $igreja)
    {
        //dd($pai);

        return view('igreja.show',compact('igreja'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Igreja  $igreja
     * @return \Illuminate\Http\Response
     */
    public function edit(Igreja $igreja)
    {
        $pais = Pais::all();

        return view('igreja.create',compact('igreja','pais'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Igreja  $igreja
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateIgrejaRequest $request, Igreja $igreja)
    {
        //die($request->all());
        if (Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {
            $igreja->update($request->all());

            return redirect()->route('igrejas.index')
                            ->with('mensagem','Igreja actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Igreja  $igreja
     * @return \Illuminate\Http\Response
     */
    public function destroy(Igreja $igreja)
    {
        if (Gate::allows('isSuperadmin')) {
            $igreja->delete();

            return redirect()->route('igrejas.index')
                            ->with('mensagem','Igreja eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }


    public function getCountries()
    {
        $countries = DB::table('pais')
                ->get();

        return $countries;
    }

    public function getState(Request $request)
    {
        $data['provincias'] = Provincia::where("pais_id",$request->pais_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }
    public function getCity(Request $request)
    {
        $data['municipios'] = Municipio::where("provincia_id",$request->provincia_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }



}
