<?php

namespace App\Http\Controllers;

use App\Models\Membro;
use App\Models\Igreja;
use App\Models\Pais;
use App\Models\Provincia;
use App\Models\Municipio;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\StoreMembroRequest;
use App\Http\Requests\UpdateMembroRequest;
use Illuminate\Http\Request;

use DB;

class MembroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $data = Membro::latest()->paginate(150);

        return view('membro.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //die($membros );
        $membros = Membro::all();
        $igrejas = Igreja::all();
        $pais = Pais::all();

        return view('membro.create',['membros' => $membros, 'igrejas' => $igrejas, 'pais' => $pais]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreMembroRequest $request)
    {
        //dd($request->all());

        if (Gate::allows('isAdmin') || Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {

            Membro::create($request->all());

            return redirect()->route('membros.index')
            ->with('mensagem','Membro registado com sucesso');
                                            }
            else{
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Membro  $membro
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
        //dd($pai);
        $ID = decrypt($id);
        $membro = Membro::findOrFail($ID);

        return view('membro.show',compact('membro'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Membro  $membro
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {

        $ID = decrypt($id);
        $membro = Membro::findOrFail($ID);
        $igrejas = Igreja::all();
        $pais = Pais::all();
        $provincias = Provincia::all();
        $municipios = Municipio::all();

        return view('membro.create',compact('membro','igrejas','pais','provincias','municipios'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Membro  $membro
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateMembroRequest $request, $id)
    {

        $ID = decrypt($id);
        $membro = Membro::findOrFail($ID);
        //die($request->all());
        if (Gate::allows('isSuperadmin') || Gate::allows('isAdmin') || Gate::allows('isGestor') ) {
            $membro->update($request->all());

            return redirect()->route('membros.index')
                            ->with('mensagem','Membro actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Membro  $membro
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request  $request,$id)
    {
        $ID = decrypt($id);
        $membro = Membro::findOrFail($ID);
        if (Gate::allows('isSuperadmin')) {
            $membro->delete();

            return redirect()->route('membros.index')
                            ->with('mensagem','Membro eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }


    public function suspenderMembro($id)
    {
        $ID = decrypt($id);
        if (Gate::allows('isSuperadmin') || Gate::allows('isGestor') ) {
            if($ID){
                $membro = Membro::find($ID);
                $membro->update([
                    'status' => 0,
                ]);
                session()->flash('message', '<i class="fa fa-check-circle"></i> Membro Suspenso!.');
                return redirect()->route('membros.index')
                ->with('mensagem','Membro Suspenso com sucesso');
            }
            else{
                return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                }
    }
}
    public function getCountries()
    {
        $countries = DB::table('pais')
                ->get();

        return $countries;
    }

    public function getState(Request $request)
    {
        $data['provincias'] = Provincia::where("pais_id",$request->pais_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }
    public function getCity(Request $request)
    {
        $data['municipios'] = Municipio::where("provincia_id",$request->provincia_id)
                    ->get(["nome","id"]);
        return response()->json($data);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoDashboard()
    {
        //die('verificar');
        $totalMembrosMasculino = DB::table('membros')
                                    ->select(DB::raw('count(*) as total_membros_masculino, genero'))
                                    ->where('genero', '=', 'M')
                                    ->groupBy('genero')
                                    ->get();

        return view('dashboard',compact('totalMembrosMasculino'));

    }

/**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function exploracaoAjax()
    {

            $array = array();

            $membros = Membro::all();


            foreach ($membros as $membro) {

               // $user = $entrada->user;
                $tmp_array = array(
                    'id' => $membro->id,

                    'igreja' => $membro->igreja->nome,
                    'municipio' => $membro->municipio->nome,
                    'nome' => $membro->nome,
                    'data_nascimento' => $membro->data_nascimento,
                    'genero' => $membro->genero,
                    'estado_civil' => $membro->estado_civil,
                    'area_formacao' => $membro->area_formacao,
                    'profissao' => $membro->profissao,
                    'grau_inst' => $membro->grauInst,
                    'data_batismo' => $membro->data_batismo,
                    'salario' => $membro->salario,
                    'igreja_batizada' => $membro->igreja_batizada,
                    'batismo_esp_santo' => $membro->batismo_esp_santo,
                    'status' => $membro->estado == '1' ? 'Activo' : 'Inactivo',
                    'doc_identificacao' => $membro->doc_identificacao,



                );

                array_push($array, $tmp_array);
            }

            return json_encode($array);

    }

    public function exploracao()
    {
        $membros = Membro::orderBy('id', 'asc')->get();
        return view('membro.exploracao',compact('membros'));
    }




}
