<?php

namespace App\Http\Controllers;

//use PDF;
//use Barryvdh\DomPDF\PDF;
use Barryvdh\DomPDF\Facade\Pdf;
//use Barryvdh\DomPDF\Facade as PDF;
use App\Models\Membro;
use App\Models\Evento;
use App\Models\Entrada;
use App\Models\Saida;

use App\Models\BemMaterial;
use Illuminate\Http\Request;

class PDFController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function membrosPDF()
    {

        $data = Membro::all();

        $pdf = PDF::loadView('exploracao.pdf.membrosPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('TodosMembros.pdf');

    }

    public function membroPDF($id)
    {
        $ID = decrypt($id);
        $membro = Membro::find($ID);

        $pdf = PDF::loadView('exploracao.pdf.membroPdf',compact('membro'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('MembroFicha.pdf');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function eventosPDF()
    {

        $data = Evento::all();

        $pdf = PDF::loadView('exploracao.pdf.eventosPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('TodosEventos.pdf');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function eventoPDF($id)
    {

        $ID = decrypt($id);
        $evento = Evento::find($ID);
        //dd($data);
        $pdf = PDF::loadView('exploracao.pdf.eventoPdf',compact('evento'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('DetalheEvento.pdf');

    }


        /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function entradasPDF()
    {

        $data = Entrada::all();

        $pdf = PDF::loadView('exploracao.pdf.entradasPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('TodasEntradas.pdf');

    }

          /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function saidasPDF()
    {

        $data = Saida::all();

        $pdf = PDF::loadView('exploracao.pdf.saidasPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('TodasSaidas.pdf');

    }

              /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function bensMateriaisPDF()
    {

        $data = BemMaterial::all();

        $pdf = PDF::loadView('exploracao.pdf.bensmateriaisPdf',compact('data'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A3', 'landscape');
        return $pdf->download('TodasBensMateriais.pdf');

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function saidaPDF($id)
    {

        $ID = decrypt($id);
        $saida = Saida::find($ID);
        //dd($data);
        $pdf = PDF::loadView('exploracao.pdf.saidaPdf',compact('saida'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A4', 'landscape');
        return $pdf->download('DetalheSaida.pdf');

    }

        /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function entradaPDF($id)
    {
        $ID = decrypt($id);

        $entrada = Entrada::find($ID);
        //dd($data);
        $pdf = PDF::loadView('exploracao.pdf.entradaPdf',compact('entrada'))
                ->setOption('images', true)
                ->setOption('enable-javascript', true)
                ->setOption('javascript-delay', 10)
                ->setOption('isPhpEnabled', true)
                ->setPaper('A4', 'landscape');
        return $pdf->download('DetalheEntrada.pdf');

    }



}
