<?php

namespace App\Http\Controllers;

use App\Models\Pais;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\StorePaisRequest;
use App\Http\Requests\UpdatePaisRequest;
use Illuminate\Http\Request;

class PaisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //die('verificar');
        $data = Pais::latest()->paginate(150);

        return view('configuracoes.pais.index',compact('data'))
            ->with('i', (request()->input('page', 1) - 1) * 150);

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        die('verificar');
        //$anolectivos = AnoLectivo::where('status',1)->get();
        //$contabancarias = ContaBancaria::all();
        $pais = Pais::all();
        return view('configuracoes.pais.create',['pais' => $pais]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePaisRequest $request)
    {
        if (Gate::allows('isAdmin') || Gate::allows('isSuperadmin') ) {

            Pais::create($request->all());

            return redirect()->route('pais.index')
                            ->with('mensagem','Pais registado com sucesso');
                                            }
            else{
                  return view('errors.message');
                }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function show(Pais $pais)
    {
        //dd($pai);
        return view('configuracoes.pais.show',compact('pais'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function edit(Pais $pais)
    {

        return view('configuracoes.pais.create',compact('pais'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePaisRequest $request, Pais $pais)
    {
        if (Gate::allows('isSuperadmin') || Gate::allows('isAdmin') ) {
            $pais->update($request->all());

            return redirect()->route('pais.index')
                            ->with('mensagem','País actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Pais  $pais
     * @return \Illuminate\Http\Response
     */
    public function destroy(Pais $pais)
    {
        if (Gate::allows('isSuperadmin')) {
            $pais->delete();

            return redirect()->route('configuracoes.pais.index')
                            ->with('mensagem','Pais eliminado com sucesso');

                        }
                        else{
                            return view('errors.message', ['mensagem' => 'Não tem autorização para executar esta acção']);
                            }
    }
}
