<?php

namespace App\Http\Controllers;

use App\Models\Provincia;
use App\Models\Pais;
use Illuminate\Support\Facades\Gate;
use App\Http\Requests\UpdateProvinciaRequest;
use Illuminate\Http\Request;

class ProvinciaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = Provincia::all();


        return view('configuracoes.provincia.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Provincia  $provincia
     * @return \Illuminate\Http\Response
     */
    public function show(Provincia $provincia)
    {
        //dd($pai);
        return view('configuracoes.provincia.show',compact('provincia'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Provincia  $provincia
     * @return \Illuminate\Http\Response
     */
    public function edit(Provincia $provincia)
    {

        $pais = Pais::all();
        return view('configuracoes.provincia.create',compact('provincia','pais'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Provincia  $provincia
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateProvinciaRequest $request, Provincia $provincia)
    {
        if (Gate::allows('isSuperadmin') || Gate::allows('isAdmin') ) {
            $provincia->update($request->all());

            return redirect()->route('provincia.index')
                            ->with('mensagem','Provincia actualizado com sucesso');
                                              }
                        else{
                            return view('errors.message');
                            }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Provincia  $provincia
     * @return \Illuminate\Http\Response
     */
    public function destroy(Provincia $provincia)
    {
        //
    }
}
