<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\FormaAquisicaoBem;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class formasAquisicaoBens extends Component
{

    use WithPagination;
    public $formasAquisicaoBens, $nome, $descricao, $formaAquisicaoBem_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\FormaAquisicaoBem,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.formas-aquisicao-bens',[
            'v_formasAquisicaoBens' =>  FormaAquisicaoBem::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

       FormaAquisicaoBem::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Forma Aquisicao Bem criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('formaAquisicaoBemStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $formaAquisicaoBem = FormaAquisicaoBem::findOrFail($ID);

        $this->formaAquisicaoBem_id = $ID;
        $this->nome = $formaAquisicaoBem->nome;
        $this->descricao = $formaAquisicaoBem->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:formas_pagamentos,nome,'.$this->formaAquisicaoBem_id,
            'descricao' => 'required'
        ]);

        if ($this->formaAquisicaoBem_id) {
            $formaPagamento = FormaAquisicaoBem::find($this->formaAquisicaoBem_id);
            $formaPagamento->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Forma Aquisicao Bem actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);


        if($ID){
            FormaAquisicaoBem::where('id',$ID)->delete();
            session()->flash('message', 'Forma Aquisicao Bem eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
