<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TipoBemMaterial;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class tiposBensMateriais extends Component
{

    use WithPagination;
    public $tiposBensMateriais, $nome, $descricao, $tipo_bens_materiais_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\TipoBemMaterial,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.tipos-bens-materiais',[
            'v_tiposBensMateriais' =>  TipoBemMaterial::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

       TipoBemMaterial::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Bem Material criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('tipoBensMateriasStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $tipoBemMaterial = TipoBemMaterial::findOrFail($ID);

        $this->tipoBemMaterial_id = $ID;
        $this->nome = $tipoBemMaterial->nome;
        $this->descricao = $tipoBemMaterial->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:tipos_eventos,nome,'.$this->tipoBemMaterial_id,
            'descricao' => 'required'
        ]);

        if ($this->tipoBemMaterial_id) {
            $tipoBemMaterial = TipoBemMaterial::find($this->tipoBemMaterial_id);
            $tipoBemMaterial->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Bem Material actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);
        if($ID){
            TipoBemMaterial::where('id',$ID)->delete();
            session()->flash('message', 'Tipo Bem Material eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
