<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TipoEntrada;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class tiposEntradas extends Component
{

    use WithPagination;
    public $tiposEntradas, $nome, $descricao, $tipoEntrada_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\TipoEntrada,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.tipos-entradas',[
            'v_tiposEntradas' =>  TipoEntrada::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

       TipoEntrada::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('tipoEntradaStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $tipoEntrada = TipoEntrada::findOrFail($ID);

        $this->tipoEntrada_id = $ID;
        $this->nome = $tipoEntrada->nome;
        $this->descricao = $tipoEntrada->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:tipos_eventos,nome,'.$this->tipoEntrada_id,
            'descricao' => 'required'
        ]);

        if ($this->tipoEntrada_id) {
            $tipoEntrada = TipoEntrada::find($this->tipoEntrada_id);
            $tipoEntrada->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);
        if($ID){
            TipoEntrada::where('id',$ID)->delete();
            session()->flash('message', 'Tipo Evento eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
