<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TipoEvento;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class tiposEventos extends Component
{

    use WithPagination;
    public $tiposeventos, $nome, $descricao, $tipoevento_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\TipoEvento,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.tipos-eventos',[
            'v_tiposeventos' =>  TipoEvento::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

        TipoEvento::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('tipoeventoStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $tipoevento = TipoEvento::findOrFail($ID);

        $this->tipoevento_id = $ID;
        $this->nome = $tipoevento->nome;
        $this->descricao = $tipoevento->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:tipos_eventos,nome,'.$this->tipoevento_id,
            'descricao' => 'required'
        ]);

        if ($this->tipoevento_id) {
            $tipoevento = TipoEvento::find($this->tipoevento_id);
            $tipoevento->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);
        if($ID){
            TipoEvento::where('id',$ID)->delete();
            session()->flash('message', 'Tipo Evento eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
