<?php

namespace App\Http\Livewire;

use Livewire\Component;
use App\Models\TipoSaida;
use Livewire\WithPagination;
use Illuminate\Validation\Rule;

class tiposSaidas extends Component
{

    use WithPagination;
    public $tiposSaidas, $nome, $descricao, $tipoSaida_id,$prompt;
    public $updateMode = false;

    protected $listeners = [
        'refresh'
    ];

    protected $rules = [
        'nome' => 'required|unique:App\Models\tipoSaida,nome',
        'descricao' => 'required'
    ];


    public function render()
    {
        //dd('vv');
        return view('livewire.tipos-saidas',[
            'v_tiposSaidas' =>  TipoSaida::paginate(100),
        ]);

    }

    private function resetInputFields(){
        $this->nome = '';
        $this->descricao = '';

    }

    public function refresh(){

        $this->prompt = 'The prompt done.';

    }

    /**
     * store
     *
     * @return void
     */
    public function store()
    {
        //dd('vv');
        // Validate Form Request
        $this->validate();


       // dd('vv');

       TipoSaida::create([
            'nome'=>$this->nome,
            'descricao'=>$this->descricao
        ]);

        session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento criada!.');

        $this->resetInputFields();
        $this->dispatchBrowserEvent('close-modal');
        //$this->emit('tipoSaidaStore'); // Close model to using to jquery

    }

    public function edit($id)
    {
        $ID = decrypt($id);
        $tipoSaida = TipoSaida::findOrFail($ID);

        $this->tipoSaida_id = $ID;
        $this->nome = $tipoSaida->nome;
        $this->descricao = $tipoSaida->descricao;

        $this->updateMode = true;
    }

    public function cancel()
    {
        $this->updateMode = false;
        $this->resetInputFields();
    }

    public function update()
    {
        $validatedDate = $this->validate([
            'nome' => 'required|unique:tipos_eventos,nome,'.$this->tipoSaida_id,
            'descricao' => 'required'
        ]);

        if ($this->tipoSaida_id) {
            $tipoSaida = TipoSaida::find($this->tipoSaida_id);
            $tipoSaida->update([
                'nome' => $this->nome,
                'descricao' => $this->descricao
            ]);
            $this->updateMode = false;
            session()->flash('message', '<i class="fa fa-check-circle"></i> Tipo Evento actualizada!.');
            $this->resetInputFields();

        }
    }

    public function delete($id)
    {
        $ID = decrypt($id);
        if($ID){
            TipoSaida::where('id',$ID)->delete();
            session()->flash('message', 'Tipo Evento eliminada!.');
        }
    }

    public function limpaCampos(){
        $this->resetInputFields();
    }
}
