<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMembroRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
                                        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'email'              => 'required',
            'nome'    => 'required|min:4',
         ];
    }

    public function messages(){
        return [
            'email.email'               => 'O email seleccionado deve ser do tipo email.',
            //'email.unique'            => 'O email seleccionado já está a ser utilizado.',
            //'nome.required'      => 'O campo Descricao é de preencimento obrigatório.',
            'telefone.required'       => 'O campo Telefone é de preenchimento obrigatório.',
            ];
    }
}
