<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePaisRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
                                        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'iso'              => 'required|min:2|max:2|unique:pais,iso,'.$this->pai->id,
            'nome'             => 'required|min:4|unique:pais,nome,'.$this->pai->id,
            'nacionalidade'    => 'required|min:4|unique:pais,nacionalidade,'.$this->pai->id,
            'iso3'             => 'nullable|min:3|max:3|unique:pais,iso3,'.$this->pai->id,
            'numcode'          => 'nullable|integer|between:1,9999|unique:pais,numcode,'.$this->pai->id,
            'indicativo'       => 'nullable|integer|between:1,9999|unique:pais,indicativo,'.$this->pai->id,
        ];
    }
}
