<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTipoEventoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (auth()->user()->role_id==1 || auth()->user()->role_id==2) {
            return true;
                                        }
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'nome' => 'required|unique:tipos_eventos',
            'descricao'    => 'required|min:4'
        ];
    }


    public function messages(){
        return [
            'nome.unique'            => 'O nome para o tipo Evento digitado já está a ser utilizado.',
            'descricao.required'      => 'O campo Descricao é de preencimento obrigatório.',
            ];
    }
}
