<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Entrada extends Model
{
    use HasFactory;

     /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'entradas';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'valor', 'descricao' ,'tipos_entradas_id', 'formas_pagamentos_id','membros_id','data_entrada'
   ];

   public function tipos_entradas()
    {
        return $this->belongsTo('App\Models\TipoEntrada');
    }

    public function formas_pagamentos()
    {
        return $this->belongsTo('App\Models\FormaPagamento');
    }

    public function membros()
    {
        return $this->belongsTo('App\Models\Membro');
    }


}
