<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Evento extends Model
{
    use HasFactory;

     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'titulo',
        'pastor',
        'data_culto',
        'horario',
        'qtd_adulto',
        'qtd_crianca',
        'qtd_conversoes',
        'qtd_visita',
        'qtd_total_part',
        'qtd_pastor_pres',
        'qtd_batizados',
        'total_dizimo',
        'total_ofertas_gerais',
        'total_ofertas_esp',
        'total_arrecadado',
        'dizimista',
        'outros',
        'igreja_id',
        'tipos_eventos_id'
      ];

      public function igreja(){
        return $this->belongsTo('App\Models\Igreja');
      }
      public function tipos_eventos(){
        return $this->belongsTo('App\Models\TipoEvento');
      }


}
