<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Igreja extends Model
{
    use HasFactory;

         /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'igrejas';

     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome', 'descricao', 'razaoSocial', 'categoria', 'email', 'endereco',
         'telefone',   'municipio_id'
      ];

      public function municipio(){
        return $this->belongsTo('App\Models\Municipio');
      }
      public function bensmateriais()
      {
           return $this->hasMany('App\Models\BemMaTerial');
      }







}
