<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Membro extends Model
{
    use HasFactory;

     /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'nome',
        'nome_pai',
        'nome_mae',
        'telefone',
        'data_nascimento',
        'genero',
        'endereco',
        'email',
        'estado_civil',
        'grauInst',
        'area_formacao',
        'profissao',
        'salario',
        'data_batismo',
        'igreja_batizada',
        'batismo_esp_santo',
        'doc_identificacao',
        'status',
        'municipio_id',
        'igrejas_id'
      ];

      public function igreja(){
        return $this->belongsTo('App\Models\Igreja','igrejas_id','id');
      }
      public function municipio(){
        return $this->belongsTo('App\Models\Municipio', 'id');
      }


}
