<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Saida extends Model
{
    use HasFactory;

     /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'saidas';


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'valor', 'descricao' ,'tipos_saidas_id', 'formas_pagamentos_id','data_saida'
   ];

   public function tipos_saidas()
    {
        return $this->belongsTo('App\Models\TipoSaida');
    }

    public function formas_pagamentos()
    {
        return $this->belongsTo('App\Models\FormaPagamento');
    }


}
