<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //

         /* define a superadmin user role */
         Gate::define('isSuperadmin', function($user) {
            return $user->role_id == 1;
         });

         /* define a Gestor user role */
         Gate::define('isGestor', function($user) {
             return $user->role_id == 2;
         });

         /* define a secretary user role */
         Gate::define('isSecretary', function($user) {
             return $user->role_id == 3;
         });

         /* define a Pastor user role */
         Gate::define('isPastor', function($user) {
            return $user->role_id == 4;
        });

        /* define a Financeiro user role */
        Gate::define('isFinanceiro', function($user) {
            return $user->role_id == 5;
        });

        /* define a Membro user role */
        Gate::define('isMember', function($user) {
            return $user->role_id == 6;
        });
    }
}
