<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('eventos', function (Blueprint $table) {
            $table->id();
           // $table->foreignId('tipo_evento_id')->constrained();
           // $table->foreignId('igreja_id')->constrained();
            $table->string('titulo')->nullable();
            $table->string('pastor')->nullable();
            $table->date('data_culto')->nullable();
            $table->timestamp('horario', $precision = 0)->nullable();
            $table->integer('qtd_adulto')->nullable();
            $table->integer('qtd_crianca')->nullable();
            $table->integer('qtd_conversoes')->nullable();
            $table->integer('qtd_visita')->nullable();
            $table->integer('qtd_total_part')->nullable();
            $table->integer('qtd_pastor_pres')->nullable();
            $table->integer('qtd_batizados')->nullable();
            $table->decimal('total_dizimo', $precision = 8, $scale = 2)->nullable();
            $table->decimal('total_ofertas_gerais', $precision = 8, $scale = 2)->nullable();
            $table->decimal('total_ofertas_esp', $precision = 8, $scale = 2)->nullable();
            $table->decimal('total_arrecadado', $precision = 8, $scale = 2)->nullable();
            $table->string('dizimista')->nullable();
            $table->string('outros')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('eventos');
    }
}
