@extends('layouts.platform')

@section('title', 'Tesouraria - caixa')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / caixa')

@if(isset($caixa))
@section('subtitle','Editar')
@else
@section('subtitle','Novo')
@endif



@section('content')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Registo De Caixas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($caixa))
            <form  id="basic-form" action="{{ route('caixas.update', encrypt($caixa->id)) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('caixas.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">

                    <div class="form-group col-md-6">
                        <label class="text-label">Estado*</label>
                        <div class="input-group">
                            <select class="form-control" name="status" >
                                <option selected>Escolhe...</option>
                                <option value="1" >Activo</option>
                                <option value="0" >Inactivo</option>

                            </select>
                        </div>
                    </div>


                    <div class="form-group col-md-6">
                        <label class="text-label">Saldo Anterior*</label>
                    <div class="input-group mb-6">

                        <div class="input-group-prepend">
                            <span class="input-group-text">$</span>
                        </div>
                        <input type="text" name="valor" id="valor" class="form-control" value="{{ $caixa->saldoAnt ?? '' }}">
                        <div class="input-group-append">
                            <span class="input-group-text">00</span>
                        </div>
                    </div>

                <div class="form-group col-md-6">
                    <label class="text-label">Saldo Actual*</label>
                <div class="input-group mb-6">

                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="text" name="valor" id="valor" class="form-control" value="{{ $caixa->saldoActual ?? '' }}">
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>
            </div>

            </div>

            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    <button type="submit" class="btn btn-info pull-right"><i class="fa fa-check-circle"></i> Salvar</button>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
@endsection


@section('javascript')
<script src="{{ asset('platform/js/formatarValorMonetario.js') }}" type="text/javascript"></script>
<script>

$("#basic-form").validate({

    rules: {
           tipos_caixas_id: {
               required: true,
           },
           valor: {
               required: true,
           },
           descricao: {
               required: true,
               min: 3,
           },


       },
		    errorPlacement:function($,t){
				    $.addClass("help-block"),
					$.insertAfter(t)},
					highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
					unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},

    });
    </script>
     <script type="text/javascript">

         function validaDouble(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;

                    //campo.value = campo.value.replace(/,/gi, ".");

                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                                return false;
                            }
                        }
                    }
                }

        function validaNumeroS(evento, valor) {
            var tecla = (window.evento) ? evento.keyCode : evento.which;
            if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
                return false;
            }
            else {
                if (tecla === 8 || tecla === 0 || tecla === 45) {
                    return true;
                }
                else {
                    valor += "" + tecla - 48;
                    if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                        return false;
                    }
                }
            }
        }

        function validaS(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;



                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor < 0) {
                                return false;
                            }
                        }
                    }
                }
</script>

<script>
    //document.getElementById("valor").onblur = function () {
        //this.value = formatarValorMonetario(this.value)

     //   this.value = new Intl.NumberFormat().format(this.value)
    //}

    new Intl.NumberFormat('en-DE').format("valor")
</script>
@endsection
