@extends('layouts.platform')

@section('title', 'Tesouraria - caixa')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / caixa')
@section('subtitle','Ver')



@section('content')

<div class="card">
    <div class="card-header">
        <h4 class="card-title">Visualização De caixas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($caixa))
            <form  id="basic-form" action="{{ route('caixas.update', $caixa->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('caixas.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Estado*</label>
                        <div class="input-group">
                            <input type="text" name="tipos_caixas" @if ($caixa->status==1)
                            value="Activo" @else value="Inactivo"   @endif class="form-control"    readonly>
                        </div>
                    </div>


                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text">Saldo Anterior$</span>
                    </div>
                    <input type="number" class="form-control" value="{{ $caixa->saldoAnt ?? '' }}" readonly>
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>

                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text">Saldo Actual$</span>
                    </div>
                    <input type="number" class="form-control" value="{{ $caixa->saldoActual ?? '' }}" readonly>
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>
            </div>
            </form>
            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    @if(Auth::user()->id == 1 )
                        <a href="{{ route('caixas.edit',$caixa->id) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('javascript')

@endsection
