@extends('layouts.platform')

@section('title', 'Configurações/Pais')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão Académica')

@section('icone','fa fa-houzz')
@section('module','Configurações/Pais')

@if(isset($pais))
@section('subtitle','Editar')
@else
@section('subtitle','Novo')
@endif


@section('content')

<div class="content-body">
            <div class="container-fluid">
                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo!</h4>
                            <span class="ml-1">Pais</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">onfigurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Pais</a></li>
                        </ol>
                    </div>
                </div>

<div class="row">
    <div class="col-md-4">
        @if (isset($pais))
        @php
         //$user = $departamento->find($departamento->id)->user;
        @endphp
        <form  id="entryForm" action="{{ route('pais.update', encrypt($pais->id)) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
        @else
        <form  id="entryForm" action="{{ route("pais.store") }}" method="POST" enctype="multipart/form-data">
        @endif

            @csrf

            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-houzz"></i> @if(isset($pais)) Editar @else Registo de @endif Configurações/Pais</h3>
                </div>
                <!-- /.box-header -->
                <div class="box-body">



                    <div class="row">
                        <div class="col-md-12">

                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Pais</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Nome</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->nome ?? '' }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Nacionalidade</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->nacionalidade ?? '' }}"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>ISO2</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->iso ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>ISO3</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->iso3 ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Numero Code</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->numcode ?? '' }}"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Indicativo</label>
                                                <input type="text" class="form-control"  placeholder="" value="{{ $pais->indicativo ?? '' }}"  maxlength="255" required>
                                            </div>



                                        </div>
                                        @error('valor')
                                <span class="text-danger">
                                    {{ $message }}
                                </span>
                                @enderror
                                <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                                        <button type="submit" class="btn btn-primary">Registar</button>
                                    </form>
                                </div>
                            </div>
                        </div>



            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    <button type="submit" class="btn btn-info pull-right"><i class="fa fa-check-circle"></i> Salvar</button>
                </div>
            </div>

        </form>
    </div>
</div>



@endsection


@section('javascript')

<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>

<script>

$("#entryForm").validate({

         rules: {
                pais_id: {
					required: true,
				},
                nome: {
					required: true,
				},
				iso: {
					required: true
                },


			},
				/*errorElement:"em",
                errorPlacement: function ( error, element ) {
					// Add the `help-block` class to the error element
					error.addClass("help-block");

					// Add `has-feedback` class to the parent div.form-group
					// in order to add icons to inputs
					//element.parents(".form-group").addClass("has-feedback");

					if (element.prop("type" ) === "checkbox" ) {
						error.insertAfter(element.parent("label"));
					} else {
						error.insertAfter(element);
					}

					// Add the span element, if doesn't exists, and apply the icon classes to it.
					if (!element.next("span")[0]) {
						$("<span class='glyphicon glyphicon-remove form-control-feedback'></span>" ).insertAfter(element);
					}
				},
				success: function ( label, element ) {
					// Add the span element, if doesn't exists, and apply the icon classes to it.
					if (!$(element).next("span")[0]) {
						$("<span class='glyphicon glyphicon-ok form-control-feedback'></span>" ).insertAfter($(element));
					}
				},
				highlight: function ( element, errorClass, validClass ) {
					$(element).parents(".form-group").addClass("has-error" ).removeClass("has-success");
					$(element).next("span").addClass("glyphicon-remove").removeClass("glyphicon-ok");
				},
				unhighlight: function ( element, errorClass, validClass ) {
					$(element).parents(".form-group").addClass("has-success").removeClass("has-error" );
					$(element).next("span").addClass("glyphicon-ok").removeClass("glyphicon-remove" );
				}*/

			    errorPlacement:function($,t){
				    $.addClass("help-block"),
					$.insertAfter(t)},
					highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
					unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},



		});

</script>

@endsection







