@extends('layouts.platform')

@section('title', 'Tesouraria - Entrada')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Entrada')
@section('subtitle','Lista')



@section('content')


    @if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Entrada</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Tesouraria</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Entradas</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="text-align: right;">

                                <h4 class="card-title">Entrada</h4>
                                <div class="btn-group">
                                    <a title="" href="{{ route('entradas.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                                    <a  class="btn btn-default btn-sm" href="{{ route('entradas.pdf') }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                                </div>


                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>

                                            <tr>
                                                <th>#</th>
                                                <th>Tipo Entrada</th>
                                                <th>Descricao</th>
                                                <th>Valor</th>
                                                <th>Forma de Entrada</th>
                                                <th>Data Recebido</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($entradas as $entrada)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $entrada->tipos_entradas->nome }}</td>
                                                <td>{{  $entrada->descricao }}</td>
                                                <td>{{  number_format($entrada->valor,2)  }}</td>
                                                <td>{{  $entrada->formas_pagamentos->nome }}</td>
                                                <td>{{ \Carbon\Carbon::parse($entrada->data_entrada)->format('d/m/Y H:i:s') }}</td>

                                                <td>{{ \Carbon\Carbon::parse($entrada->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('entradas.show',encrypt($entrada->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        @if(Auth::user()->id == 1 )
                                                            <a title="Editar" href="{{ route('entradas.edit',encrypt($entrada->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                        @endif
                                                    </div>

                                                </td>

                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection


@section('javascript')

@endsection
