@extends('layouts.platform')

@section('title', 'Tesouraria - Entrada')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Entrada')
@section('subtitle','Ver')



@section('content')

<div class="card">
    <div class="card-header">
        <h4 class="card-title">Registo De Entradas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($entrada))
            <form  id="basic-form" action="{{ route('entradas.update', $entrada->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('entradas.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Tipo De Entrada*</label>
                        <div class="input-group">
                            <input type="text" name="tipos_entradas" value="{{ $entrada->tipos_entradas->nome  }}" class="form-control"    readonly>


                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Forma De Entrada*</label>
                        <div class="input-group">
                            <input type="text" name="forma_pagamento" value="{{ $entrada->formas_pagamentos->nome  }}" class="form-control"    readonly>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Data Recebido*</label>
                        <div class="input-group">
                            <input type="date" name="data_entrada" value="{{ $entrada->data_entrada ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Descrição*</label>
                        <div class="input-group">
                            <input type="text" name="descricao" value="{{ $entrada->descricao ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>

                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="number" class="form-control" value="{{ $entrada->valor ?? '' }}" readonly>
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>



            </form>
            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    @if(Auth::user()->id == 1 )
                        <a href="{{ route('entradas.edit',encrypt($entrada->id)) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>
                    @endif
                    <a  class="btn btn-default btn-sm" href="{{ route('entrada.pdf',encrypt($entrada->id)) }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('javascript')

@endsection
