@extends('layouts.platform')

@section('title', 'Eventos - Evento')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Eventos')

@section('icone','fa fa-houzz')
@section('module','Eventos/Evento')
@section('subtitle','Lista')



@section('content')

@if (session('mensagem'))
<div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                {{ session('mensagem') }}.
              </div>
@endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Evento</span>
                        </div>

                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Eventos</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Evento</a></li>
                        </ol>


                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="text-align: right;">

                                <h4 class="card-title">Eventos</h4>
                               <!--<button type="button" class="btn btn-outline-dark" > Adicionar</button>-->
                               <div class="btn-group">
                                    <a title="" href="{{ route('eventos.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                                    <a  class="btn btn-default btn-sm" href="{{ route('eventos.pdf') }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Evento</th>
                                                <th>Igreja</th>
                                                <th>Titulo</th>
                                                <th>Pastor Realizador</th>
                                                <th>Data Do Culto</th>
                                                <th>Horario</th>
                                                <th>Total Participantes</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($data as $evento)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $evento->tipos_eventos->nome }}</td>

                                                <td>{{  $evento->igreja->nome }}</td>

                                                <td>{{  $evento->titulo }}</td>

                                                <td>{{  $evento->pastor }}</td>

                                                <td>{{  $evento->data_culto }}</td>

                                                <td>{{  $evento->horario }}</td>

                                                <td>{{  $evento->qtd_total_part }}</td>


                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('eventos.show',encrypt($evento->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        <a title="Editar" href="{{ route('eventos.edit',encrypt($evento->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                    </div>

                                                    </td>

                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection

@section('javascript')
<script>
 window.setTimeout(function(){
	 $(".alert").fadeTo(500,0).slideUp(500, function(){
		 $(this).remove();
	 });
 }, 3000);
</script>
@endsection







