@include('livewire.tipoEntrada.create')
@include('livewire.tipoEntrada.update')

@if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--****************************pagamentos******
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Tipos Entradas</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Tipo Entrada</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Tipos Entradas</h4>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createTipoEntradaModal"><i class="fa fa-plus-circle"></i> Adicionar</button>

                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            {{ $prompt }}
                                            <tr>
                                                <th>#</th>
                                                <th>Nome</th>

                                                <th>Descricao</th>
                                                <th>Data de registo</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($v_tiposEntradas as $tipoentrada)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>


                                                <td>{{  $tipoentrada->nome }}</td>

                                                <td>{{  $tipoentrada->descricao }}</td>

                                                <td>{{ \Carbon\Carbon::parse($tipoentrada->created_at)->format('d/m/Y H:i:s') }}</td>
                                                <td>{{ \Carbon\Carbon::parse($tipoentrada->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align: center;">

                                                        <button data-toggle="modal" data-target="#updateModal" wire:click="edit({{ encrypt($tipoentrada->id) }})" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                        @if(Auth::user()->role_id == 1 )
                                                            <button wire:click="delete({{ encrypt($tipoentrada->id) }})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></button>
                                                        @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>
                                    {{ $v_tiposEntradas->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>




