 <!-- Modal -->
 <div  wire:ignore.self class="modal fade" tabindex="-1"    id="createUserModal"   >
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Registar Utilizador</h5>
                <button type="button" class="close" data-dismiss="modal" wire:click.prevent="limpaCampos()"><span>&times;</span>
                </button>
            </div>

            <div class="modal-body">
                <form >
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Perfil<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <select wire:model.defer="role_id" class="form-control" >
                                <option value=""></option>
                                @foreach($roles as $role)
                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endforeach

                            </select>
                        </div>
                        @error('role_id') <span class="text-danger error">{{ $message }}</span>@enderror
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Nome<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <input wire:model.defer="name" type="text" class="form-control"   >
                            @error('name') <span class="text-danger error">{{ $message }}</span>@enderror

                        </div>
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Email</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" wire:model.defer="email" >
                            @error('email') <span class="text-danger error">{{ $message }}</span>@enderror

                        </div>
                    </div>

                    @if ($errors->any())
                    <ul class="text-danger">
                        @foreach ( $errors->all() as $error )
                            <li class="text-danger">{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif

                <div class="modal-footer">
                    <button type="button" class="btn btn-default close-btn" data-dismiss="modal"> Cancelar</button>

                    <button type="submit" class="btn btn-info close-modal" wire:click.prevent="userStore()"><i class="fa fa-check"></i> Salvar</button>
                </div>


                </form>
            </div>



        </div>
    </div>
</div>
