
@include('livewire.user.create')
@if (session()->has('message'))
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        {!! session('message') !!}
    </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Utilizadores</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Utilizadores</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Users</h4>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createUserModal"><i class="fa fa-plus-circle"></i> Adicionar</button>

                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Photo</th>
                                                <th>Nome</th>
                                                <th>Perfil</th>
                                                <th>Email</th>
                                                <th>Data de registo</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Estado</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($v_users as $user)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $user->profile_photo_path }}</td>

                                                <td>{{  $user->name }}</td>

                                                <td>{{  $user->role->description }}</td>

                                                <td>{{  $user->email }}</td>

                                                <td>{{ \Carbon\Carbon::parse($user->created_at)->format('d/m/Y H:i:s') }}</td>
                                                <td>{{ \Carbon\Carbon::parse($user->updated_at)->format('d/m/Y H:i:s') }}</td>
                                                <td style="text-align:center;">
                                                    @if($user->status==1)
                                                        <small class="label  bg-green">Activo</small>
                                                    @else
                                                        <small class="label  bg-red">Inactivo</small>
                                                    @endif
                                                </td>

                                                <td style="text-align: center;">
                                                    @if($user->status==1)
                                                        <button data-toggle="modal" data-target="#updateModal" wire:click="edit({{ encrypt($user->id) }})" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                        <button wire:click="restorePassword({{ encrypt($user->id) }})" class="btn btn-warning btn-sm"><i class="fa fa-undo"></i></button>

                                                        @if(Auth::user()->id != $user->id )
                                                        <button wire:click="disableUser({{ encrypt($user->id) }})" class="btn btn-danger btn-sm"><i class="fa fa-user-times"></i></button>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>
                                    {{ $v_users->links() }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



@section('javascript')



    <script type="text/javascript">
        window.livewire.on('userStoreCl', () => {
            $('#create1Modal').modal('hide');
        });

        window.setTimeout(function(){
            $(".alert-success").fadeTo(1000,0).slideUp(1000, function(){
                $(this).remove();
            });
                    }, 3000);
        window.setTimeout(function(){
            $(".alert-warning").fadeTo(1000,0).slideUp(1000, function(){
            $(this).remove();
                });
        }, 3000);
    </script>

@endsection
