@extends('layouts.platform')

@section('title', 'Membros/Membro')

@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Gestão De Membros')

@section('icone','fa fa-houzz')
@section('module','Membros/Membro')

@if(isset($membros))
@section('subtitle','Editar')
@else
@section('subtitle','Novo')
@endif


@section('content')



<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Membros</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Membros</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Membro</a></li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-6 col-xxl-12">


        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-houzz"></i> @if(isset($membro)) Editar @else Registo de @endif Membros/Membro</h3>
            </div>
            <!-- /.box-header -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Membro</h4>
                        </div>
                        <div class="card-body">
                            <div class="basic-form">
            @if (isset($membro))
                <form  id="step-form-horizontal" action="{{ route('membros.update', encrypt($membro->id)) }}" method="POST" enctype="multipart/form-data">
                @method('PUT')
            @else
                <form  id="step-form-horizontal" action="{{ route('membros.store') }}" method="POST" enctype="multipart/form-data">

                @endif
                @csrf


                        <div>
                            <h4>Dados Pessoais</h4>
                            <section>
                                <div class="row">
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Nome*</label>
                                            <input type="text" name="nome" value="{{ $membro->nome ?? '' }}"  maxlength="255" class="form-control"  required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Nome do Pai*</label>
                                            <input type="text" name="nome_pai" value="{{ $membro->nome_pai ?? '' }}"  maxlength="255" class="form-control"  required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Nome da Mãe*</label>
                                            <input type="text" name="nome_mae" value="{{ $membro->nome_mae ?? '' }}"  maxlength="255" class="form-control"  required>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Data De Nascimento*</label>
                                            <div class="input-group">
                                                <input type="date" name="data_nascimento" value="{{ $membro->data_nascimento ?? '' }}" class="form-control"    required>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Genero*</label>
                                            <select class="form-control" name="genero" id="genero">

                                                <option value="M" @if(isset($membro))  {{ $membro->genero ==  "M"  ? "selected":""  }} @endif>Masculino</option>
                                                <option value="F" @if(isset($membro)) {{  $membro->genero ==  "F"  ? "selected":""  }} @endif>Feminino</option>
                                                <option value="O" @if(isset($membro)) {{  $membro->genero ==  "O"  ? "selected":""  }} @endif>Outros</option>


                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Estado civil*</label>
                                            <select class="form-control" name="estado_civil" id="estado_civil">
                                                <option selected>Escolhe...</option>
                                                <option value="S" @if(isset($membro))  {{ $membro->estado_civil ==  "S"  ? "selected":""  }} @endif>Solteiro (a)</option>
                                                <option value="C" @if(isset($membro))  {{ $membro->estado_civil ==  "C"  ? "selected":""  }} @endif>Casado (a)</option>
                                                <option value="D" @if(isset($membro))  {{ $membro->estado_civil ==  "D"  ? "selected":""  }} @endif>Divorciado (a)</option>
                                                <option value="V" @if(isset($membro))  {{ $membro->estado_civil ==  "V"  ? "selected":""  }} @endif>Viuvo (a)</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </section>
                            <h4>Endereço / Contacto</h4>
                            <section>
                            <div class="row">

                            @if (isset($membro))

                            <div class="col-lg-6 mb-4">
                                <div class="form-group">
                                    <label class="text-label">Pais*</label>
                                    <div class="input-group">
                                        <select class="form-control" name="pais_id" id="country-dropdown">
                                            <option selected>Escolhe...</option>
                                            @foreach($pais as $pais)
                                            @if ($membro->municipio->provincia->pais_id == $pais->id)
                                            <option selected value={{ $pais->id }}>{{ $pais->nome }}</option>
                                            @else
                                            <option value={{ $pais->id }}>{{ $pais->nome }}</option>
                                            @endif

                                        @endforeach

                                        </select>
                                    </div>
                                </div>
                            </div>



                            @else
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Pais*</label>
                                            <div class="input-group">
                                                <select class="form-control" name="pais_id" id="country-dropdown">
                                                    <option selected>Escolhe...</option>
                                                    @foreach($pais as $pais)
                                                    <option value="{{ $pais->id }}" >
                                                    {{ $pais->nome }}
                                                    </option>
                                                @endforeach

                                                </select>
                                            </div>
                                        </div>
                                    </div>
                            @endif

                            @if (isset($membro))
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Provincia*</label>
                                        <div class="input-group">
                                            <select class="form-control" name="provincia_id" id="state-dropdown">
                                                @foreach($provincias as $provincia)
                                                @if ($membro->municipio->provincia_id == $provincia->id)
                                                <option selected value={{ $provincia->id }}>{{ $provincia->nome }}</option>
                                                @else
                                                <option value={{ $provincia->id }}>{{ $provincia->nome }}</option>
                                                @endif
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <div class="col-lg-6 mb-4">
                                <div class="form-group">
                                    <label class="text-label">Provincia*</label>
                                    <div class="input-group">

                                        <select class="form-control" name="provincia_id" id="state-dropdown">


                                        </select>
                                    </div>
                                </div>
                                </div>
                            @endif

                            @if (isset($membro))
                            <div class="col-lg-6 mb-4">
                                <div class="form-group">
                                    <label class="text-label">Municipio*</label>
                                    <div class="input-group">
                                        <select id="city-dropdown" class="form-control" name="municipio_id">
                                            @foreach($municipios as $municipio)
                                            @if ($membro->municipio_id == $municipio->id)
                                            <option selected value={{ $municipio->id }}>{{ $municipio->nome }}</option>
                                            @else
                                            <option value={{ $municipio->id }}>{{ $municipio->nome }}</option>
                                            @endif
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                            </div>

                            @else
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Municipio*</label>
                                        <div class="input-group">
                                            <select id="city-dropdown" class="form-control" name="municipio_id">

                                            </select>
                                        </div>
                                    </div>
                                </div>
                            @endif
                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Email*</label>
                                            <div class="input-group">
                                                <input type="email" name="email" value="{{ $membro->email ?? '' }}"class="form-control"  required>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Endereeço*</label>
                                            <div class="input-group">
                                                <input type="text" name="endereco" value="{{ $membro->endereco ?? '' }}"class="form-control"  required>

                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Telefone*</label>
                                            <div class="input-group">
                                                <input type="text" name="telefone" value="{{ $membro->telefone ?? '' }}"class="form-control"  required>

                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </section>
                            <h4>Dados Profissionais</h4>
                            <section>
                                <div class="row">
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Profissão *</label>
                                        <div class="input-group">
                                            <input name="profissao" value="{{ $membro->profissao ?? '' }}"class="form-control" type="text" required>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Área de Formação *</label>
                                        <div class="input-group">
                                            <input name="area_formacao" value="{{ $membro->area_formacao ?? '' }}"class="form-control" type="text" required>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Grau de Instituição *</label>
                                        <div class="input-group">
                                            <input name="grauInst" value="{{ $membro->grauInst ?? '' }}"class="form-control" type="text" required>

                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Salario *</label>
                                        <div class="input-group">
                                            <input name="salario" value="{{ $membro->salario ?? '' }}"class="form-control" type="number" required>

                                        </div>
                                    </div>
                                </div>




                            </div>
                            </section>
                            <h4>Dados Da Igreja</h4>
                            <section>
                                <div class="row">


                                    @if (isset($membro))

                                    <div class="col-lg-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Igreja Actual*</label>
                                            <select class="form-control" name="igreja_id">

                                                @foreach($igrejas as $igreja)
                                                @if ($membro->igreja_id == $igreja->id)
                                                <option selected value="{{ $igreja->id }}" >
                                                    {{ $igreja->nome }}
                                                </option>
                                                @else
                                                <option  value="{{ $igreja->id }}" >
                                                    {{ $igreja->nome }}
                                                @endif
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>
                                    @else


                                    <div class="col-lg-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-label">Igreja Actual*</label>
                                            <select class="form-control" name="igreja_id">
                                                <option selected>Escolhe a igreja</option>
                                                @foreach($igrejas as $igreja)

                                                <option value="{{ $igreja->id }}" >
                                                    {{ $igreja->nome }}
                                                </option>
                                                @endforeach

                                            </select>
                                        </div>
                                    </div>
                                    @endif
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label  class="text-label">Igreja Onde Batizou*</label>
                                        <div class="input-group">
                                            <input type="text" name="igreja_batizada" value="{{ $membro->igreja_batizada ?? '' }}" class="form-control"   required>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label  class="text-label">Batismo de Espirito Santo ?*</label>
                                        <div class="input-group">
                                            <select class="form-control" name="batismo_esp_santo" id="batismo_esp_santo">
                                                <option selected>Escolhe...</option>
                                                <option value="Sim" @if(isset($membro))  {{ $membro->batismo_esp_santo ==  "Sim"  ? "selected":""  }} @endif>Sim</option>
                                                <option value="Nao" @if(isset($membro))  {{ $membro->batismo_esp_santo ==  "Nao"  ? "selected":""  }} @endif>Não</option>

                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label  class="text-label">Data de Batispo*</label>
                                        <div class="input-group">
                                            <input type="date"  name="data_batismo" value="{{ $membro->data_batismo ?? '' }}" class="form-control"  required>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 mb-4">
                                    <div class="form-group">
                                        <label class="text-label">Número Documento Identificação*</label>
                                        <div class="input-group">
                                            <input name="doc_identificacao" value="{{ $membro->doc_identificacao ?? '' }}"class="form-control" type="text"required>

                                        </div>
                                    </div>
                                </div>


                                </div>
                            </div>
                            </section>

                            <input type="hidden" name="status" value="1" />

                            @if ($errors->any())
                            <ul class="text-danger">
                                @foreach ( $errors->all() as $error )
                                    <li class="text-danger">{{ $error }}</li>
                                @endforeach
                            </ul>
                        @endif




                            </div>



                            </div>
                        </div>
                    </div>


        </div>

    </form>

    </div>
</div>



@endsection


@section('javascript')


<script src="{{ asset('assets/js/jquery.validate.min.js')}}"></script>
<script src="{{ asset('assets/js/messages_pt_PT.min.js')}}"></script>

<script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var pais_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"{{url('get-states-by-country')}}",
    type: "POST",
    data: {
    pais_id: pais_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#state-dropdown').html('<option value="">Escolhe a Provincia</option>');
    $.each(result.provincias,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    $('#city-dropdown').html('<option value="">Escolhe Primeiro a Provincia</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var provincia_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"{{url('get-cities-by-state')}}",
    type: "POST",
    data: {
    provincia_id: provincia_id,
    _token: '{{csrf_token()}}'
    },
    dataType : 'json',
    success: function(result){
    $('#city-dropdown').html('<option value="">Escolhe o Municipio</option>');
    $.each(result.municipios,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    }
    });
    });
    });



$("#step-form-horizontal").validate({



rules: {
       email: {
           required: true,
           email:true
       },
       status: {
           required: true

       }


   },




       errorPlacement:function($,t){
           $.addClass("help-block"),
           $.insertAfter(t)},
           highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
           unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},



});

$('#step-form-horizontal').steps({
    onFinish: function () { alert('complete'); }
  });

</script>

@endsection







