@extends('layouts.platform')

@section('title', 'Tesouraria - Saida')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Saida')
@section('subtitle','Lista')



@section('content')


    @if (session()->has('message'))
     <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
          {!! session('message') !!}
     </div>
    @endif

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Saida</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Tesouraria</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Saidas</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header" style="text-align: right;">

                                <h4 class="card-title">Saida</h4>
                                <div class="btn-group">
                                    <a title="" href="{{ route('saidas.create') }}" class="btn btn-outline-dark"><i class="fa fa-plus-circle"></i> Adicionar</a>

                                    <a  class="btn btn-default btn-sm" href="{{ route('saidas.pdf') }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                                </div>


                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>

                                            <tr>
                                                <th>#</th>
                                                <th>Tipo saida</th>
                                                <th>Descricao</th>
                                                <th>Valor</th>
                                                <th>Forma de saida</th>
                                                <th>Data Recebido</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($saidas as $saida)
                                            <tr>
                                                <td>{{  $loop->index +1 }}</td>

                                                <td>{{  $saida->tipos_saidas->nome }}</td>
                                                <td>{{  $saida->descricao }}</td>
                                                <td>{{  number_format($saida->valor,2)  }}</td>
                                                <td>{{  $saida->formas_pagamentos->nome }}</td>
                                                <td>{{ \Carbon\Carbon::parse($saida->data_saida)->format('d/m/Y H:i:s') }}</td>

                                                <td>{{ \Carbon\Carbon::parse($saida->updated_at)->format('d/m/Y H:i:s') }}</td>


                                                <td style="text-align:center;">

                                                    <div class="btn-group">
                                                            <a title="Ver" href="{{ route('saidas.show',encrypt($saida->id)) }}" class="btn btn-default btn-sm"><i class="fa fa-eye"></i></a>
                                                    </div>

                                                    <div class="btn-group">
                                                        @if(Auth::user()->role_id == 1 )
                                                        <a title="Editar" href="{{ route('saidas.edit',encrypt($saida->id)) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></a>
                                                        @endif
                                                    </div>

                                                </td>

                                            </tr>
                                            @endforeach
                                        </tbody>

                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


@endsection


@section('javascript')

@endsection
