@extends('layouts.platform')

@section('title', 'Tesouraria - Saida')


@section('icone-modulo',"fa fa-building")
@section('titulopagina', 'Ngola Gestão De Igrejas')

@section('icone','fa fa-houzz')
@section('module','Tesouraria / Saida')
@section('subtitle','Ver')



@section('content')

<div class="card">
    <div class="card-header">
        <h4 class="card-title">Visualização De saidas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            @if (isset($saida))
            <form  id="basic-form" action="{{ route('saidas.update', $saida->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @else
            <form  id="basic-form" action="{{ route('saidas.store') }}" method="POST" enctype="multipart/form-data">

            @endif
            @csrf
            @if ($errors->any())
            <ul class="text-danger">
                @foreach ( $errors->all() as $error )
                    <li class="text-danger">{{ $error }}</li>
                @endforeach
            </ul>
            @endif
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Tipo De Saida*</label>
                        <div class="input-group">
                            <input type="text" name="tipos_saidas" value="{{ $saida->tipos_saidas->nome  }}" class="form-control"    readonly>


                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Forma De Saida*</label>
                        <div class="input-group">
                            <input type="text" name="forma_pagamento" value="{{ $saida->formas_pagamentos->nome  }}" class="form-control"    readonly>

                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Data Recebido*</label>
                        <div class="input-group">
                            <input type="date" name="data_saida" value="{{ $saida->data_saida ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Descrição*</label>
                        <div class="input-group">
                            <input type="text" name="descricao" value="{{ $saida->descricao ?? '' }}" class="form-control"    readonly>
                        </div>
                    </div>

                </div>
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="number" class="form-control" value="{{ $saida->valor ?? '' }}" readonly>
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>

            </form>
            <div class="box">
                <div class="box-footer">
                    <a href="{{ URL::previous() }}" class="btn btn-default">Retroceder</a>
                    <a href="{{ route('saidas.edit',encrypt($saida->id)) }}" class="btn btn-info"><i class="fa fa-edit"></i> Editar</a>
                    <a  class="btn btn-default btn-sm" href="{{ route('saida.pdf',encrypt($saida->id)) }}" target="_blank"><i class="fa fa-print"></i> Imprimir</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection


@section('javascript')

@endsection
