<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PaisController;
use App\Http\Controllers\IgrejaController;
use App\Http\Controllers\MembroController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\EntradaController;
use App\Http\Controllers\SaidaController;
use App\Http\Controllers\BemMaterialController;
use App\Http\Controllers\CaixaController;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\EventoController;
use App\Http\Controllers\ProvinciaController;
use App\Http\Controllers\MunicipioController;

use App\Http\Livewire\Users;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

//Route::get('lang/{locale}', [LocalizationController::class, 'lang']);

 //Auth::routes(['register' => false]);

//Igrejas
//Route::get('igrejas', [IgrejaController::class, 'index'])->middleware('auth')->name('igreja.index');
//Route::get('igrejas/create', [IgrejaController::class, 'create'])->middleware('auth')->name('igreja.create');
//Route::post('igrejas/store', [IgrejaController::class, 'store'])->middleware('auth')->name('igreja.store');

//Membros
Route::resource('membros', MembroController::class)->middleware('auth');
Route::get('/membro/exploracao', [MembroController::class, 'exploracao'])->middleware('auth')->name('membros.exploracao');
Route::get('/membro/exploracaoAjax', [MembroController::class, 'exploracaoAjax'])->middleware('auth')->name('membros.exploracaoAjax');
Route::get('membro/{id}/suspender', [MembroController::class, 'suspenderMembro'])->middleware('auth')->name('membros.suspencao');

//Igreja
Route::resource('igrejas', IgrejaController::class)->middleware('auth');

//Eventos
Route::resource('eventos', EventoController::class)->middleware('auth');
Route::get('/evento/exploracao', [EventoController::class, 'exploracao'])->middleware('auth')->name('eventos.exploracao');
Route::get('/evento/exploracaoAjax', [EventoController::class, 'exploracaoAjax'])->middleware('auth')->name('eventos.exploracaoAjax');



////////////////////////  Tesouraria
//entradas
Route::resource('tesouraria/entradas', EntradaController::class)->middleware('auth');
//Route::get('tesouraria/entradas/{id}/edit', [EntradaController::class, 'edit'])->middleware('auth')->name('entradas.edit');
Route::get('/entrada/exploracao', [EntradaController::class, 'exploracao'])->middleware('auth')->name('entrada.exploracao');
Route::get('/entrada/exploracaoAjax', [EntradaController::class, 'exploracaoAjax'])->middleware('auth')->name('entrada.exploracaoAjax');

/////////////////////////////////////////////////fim entradas


//Bens Materiais
Route::resource('equipamento/bensmateriais', BemMaterialController::class)->middleware('auth');
//Route::get('tesouraria/entradas/{id}/edit', [EntradaController::class, 'edit'])->middleware('auth')->name('entradas.edit');
Route::get('/bemMaterial/exploracao', [BemMaterialController::class, 'exploracao'])->middleware('auth')->name('bemmaterial.exploracao');
Route::get('/bemMaterial/exploracaoAjax', [BemMaterialController::class, 'exploracaoAjax'])->middleware('auth')->name('bemmaterial.exploracaoAjax');
Route::post('deprecicao/store', [BemMaterialController::class, 'deprecicao'])->middleware('auth')->name('depreciacao.store');



////////////////////////////saidas
Route::resource('tesouraria/saidas', SaidaController::class)->middleware('auth');
Route::get('/saida/exploracao', [SaidaController::class, 'exploracao'])->middleware('auth')->name('saida.exploracao');
Route::get('/saida/exploracaoAjax', [SaidaController::class, 'exploracaoAjax'])->middleware('auth')->name('saida.exploracaoAjax');


////////////////////////////////////////fim saidas

//caixas
Route::resource('tesouraria/caixas', CaixaController::class)->middleware('auth');

//////////////Buscar pais provincias combobox dependente no Membro

Route::get('country-state-city', [MembroController::class, 'index']);
Route::post('get-states-by-country', [MembroController::class, 'getState']);
Route::post('get-cities-by-state', [MembroController::class, 'getCity']);

//////////////////////////////fim



//////////////////////// Dashboard

Route::get('/dashboard', [HomeController::class, 'dashboard'])->middleware('auth')->name('dashboard');

/////////////// fim Dashboard


//Buscar pais provincias combobox dependente na Igreja
Route::get('country-state-city', [IgrejaController::class, 'index']);
Route::post('get-states-by-country', [IgrejaController::class, 'getState']);
Route::post('get-cities-by-state', [IgrejaController::class, 'getCity']);


/////////////// Configurações
// municipios
Route::resource('municipios', MunicipioController::class)->middleware('auth');

//Provincias
Route::resource('provincias', ProvinciaController::class)->middleware('auth');

//Pais
Route::resource('pais', PaisController::class)->only(['index', 'show','edit', 'update'])->middleware('auth');
Route::get('pais/create', [PaisController::class, 'create'])->middleware('auth')->name('pais.create');
Route::post('pais/store', [PaisController::class, 'store'])->middleware('auth')->name('pais.store');

////////////////////////////////fim configurações


//Livewires Modals
//Route::post('/register', [Users::class, 'store'])->middleware('auth')->name('register');
Route::view('users','livewire.user.index')->middleware('auth')->name('users');
Route::view('tesouraria/tiposeventos','livewire.tipoEvento.index')->middleware('auth')->name('tiposeventos');
Route::view('tesouraria/tiposentradas','livewire.tipoEntrada.index')->middleware('auth')->name('tiposentradas');
Route::view('tesouraria/tipossaidas','livewire.tipoSaida.index')->middleware('auth')->name('tipossaidas');
Route::view('formaspagamentos','livewire.formaPagamento.index')->middleware('auth')->name('formaspagamentos');
Route::view('formasaquisicaobens','livewire.formaAquisicaoBem.index')->middleware('auth')->name('formasaquisicaobens');
Route::view('equipamento/tiposbensmateriais','livewire.tipoBemMaterial.index')->middleware('auth')->name('tiposbensmateriais');
/////// Fim Modals



//Relatorios Em PDF
Route::get('membros-pdf', [PDFController::class, 'membrosPDF'])->middleware('auth')->name('membros.pdf');
Route::get('membro-pdf/{id}', [PDFController::class, 'membroPDF'])->middleware('auth')->name('membro.pdf');
Route::get('eventos-pdf', [PDFController::class, 'eventosPDF'])->middleware('auth')->name('eventos.pdf');
Route::get('evento-pdf/{id}', [PDFController::class, 'eventoPDF'])->middleware('auth')->name('evento.pdf');
Route::get('entrada-pdf/{id}', [PDFController::class, 'entradaPDF'])->middleware('auth')->name('entrada.pdf');
Route::get('saida-pdf/{id}', [PDFController::class, 'saidaPDF'])->middleware('auth')->name('saida.pdf');
Route::get('entradas-pdf', [PDFController::class, 'entradasPDF'])->middleware('auth')->name('entradas.pdf');
Route::get('saidas-pdf', [PDFController::class, 'saidasPDF'])->middleware('auth')->name('saidas.pdf');
Route::get('bensmateriais-pdf', [PDFController::class, 'bensMateriaisPDF'])->middleware('auth')->name('bensmateriais.pdf');

/////////////////Relatorios Pdf Fim

//Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
//    return view('dashboard');
//})->name('dashboard');
