<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PaisController;
use App\Http\Controllers\IgrejaController;
use App\Http\Controllers\MembroController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PDFController;
use App\Http\Controllers\EventoController;
use App\Http\Controllers\ProvinciaController;
use App\Http\Controllers\MunicipioController;

use App\Http\Livewire\Users;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

//Route::get('lang/{locale}', [LocalizationController::class, 'lang']);

 //Auth::routes(['register' => false]);

//Igrejas
//Route::get('igrejas', [IgrejaController::class, 'index'])->middleware('auth')->name('igreja.index');
//Route::get('igrejas/create', [IgrejaController::class, 'create'])->middleware('auth')->name('igreja.create');
//Route::post('igrejas/store', [IgrejaController::class, 'store'])->middleware('auth')->name('igreja.store');

Route::resource('membros', MembroController::class)->middleware('auth');
Route::resource('igrejas', IgrejaController::class)->middleware('auth');
Route::resource('eventos', EventoController::class)->middleware('auth');

//Buscar pais provincias combobox dependente
Route::get('country-state-city', [MembroController::class, 'index']);
Route::post('get-states-by-country', [MembroController::class, 'getState']);
Route::post('get-cities-by-state', [MembroController::class, 'getCity']);

Route::get('/dashboard', [HomeController::class, 'dashboard'])->middleware('auth')->name('dashboard');

//Buscar pais provincias combobox dependente
Route::get('country-state-city', [IgrejaController::class, 'index']);
Route::post('get-states-by-country', [IgrejaController::class, 'getState']);
Route::post('get-cities-by-state', [IgrejaController::class, 'getCity']);

Route::resource('municipios', MunicipioController::class)->middleware('auth');
Route::resource('provincias', ProvinciaController::class)->middleware('auth');

Route::resource('pais', PaisController::class)->only(['index', 'show','edit', 'update'])->middleware('auth');
Route::get('pais/create', [PaisController::class, 'create'])->middleware('auth')->name('pais.create');
Route::post('pais/store', [PaisController::class, 'store'])->middleware('auth')->name('pais.store');

//Route::post('/register', [Users::class, 'store'])->middleware('auth')->name('register');
Route::view('users','livewire.user.index')->middleware('auth')->name('users');
Route::view('tiposeventos','livewire.tipoEvento.index')->middleware('auth')->name('tiposeventos');

Route::get('membros-pdf', [PDFController::class, 'membrosPDF'])->middleware('auth')->name('membros.pdf');
Route::get('eventos-pdf', [PDFController::class, 'eventosPDF'])->middleware('auth')->name('eventos.pdf');
Route::get('evento-pdf/{id}', [PDFController::class, 'eventoPDF'])->middleware('auth')->name('evento.pdf');


//Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
//    return view('dashboard');
//})->name('dashboard');
