<?php $__env->startSection('title', 'Tesouraria - Saida'); ?>


<?php $__env->startSection('icone-modulo',"fa fa-building"); ?>
<?php $__env->startSection('titulopagina', 'Ngola Gestão De Igrejas'); ?>

<?php $__env->startSection('icone','fa fa-houzz'); ?>
<?php $__env->startSection('module','Tesouraria / Saida'); ?>

<?php if(isset($saida)): ?>
<?php $__env->startSection('subtitle','Editar'); ?>
<?php else: ?>
<?php $__env->startSection('subtitle','Novo'); ?>
<?php endif; ?>



<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Registo De Saidas</h4>
    </div>
    <div class="card-body">
        <div class="basic-form">

            <?php if(isset($saida)): ?>
            <form  id="basic-form" action="<?php echo e(route('saidas.update', encrypt($saida->id))); ?>" method="POST" enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php else: ?>
            <form  id="basic-form" action="<?php echo e(route('saidas.store')); ?>" method="POST" enctype="multipart/form-data">

            <?php endif; ?>
            <?php echo csrf_field(); ?>
            <?php if($errors->any()): ?>
            <ul class="text-danger">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="text-danger"><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php endif; ?>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label class="text-label">Tipo De Saida*</label>
                        <div class="input-group">
                            <select class="form-control" name="tipos_saidas_id" >
                                <option selected>Escolhe...</option>
                                <?php $__currentLoopData = $tipossaidas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tiposaida): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tiposaida->id); ?>" > <?php echo e($tiposaida->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Forma De Saida*</label>
                        <div class="input-group">
                            <select class="form-control" name="formas_pagamentos_id" >
                                <option selected>Escolhe...</option>
                                <?php $__currentLoopData = $formaspagamentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formapagamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($formapagamento->id); ?>" > <?php echo e($formapagamento->nome); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Data Saida*</label>
                        <div class="input-group">
                            <input type="date" name="data_saida" value="<?php echo e($saida->data_saida ?? ''); ?>" class="form-control"    required>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <label class="text-label">Descrição*</label>
                        <div class="input-group">
                            <input type="text" name="descricao" value="<?php echo e($saida->descricao ?? ''); ?>" class="form-control"    required>
                        </div>
                    </div>


                <div class="form-group col-md-6">
                    <label class="text-label">Valor*</label>
                <div class="input-group mb-6">

                    <div class="input-group-prepend">
                        <span class="input-group-text">$</span>
                    </div>
                    <input type="text" name="valor" id="valor" class="form-control" value="<?php echo e($saida->valor ?? ''); ?>">
                    <div class="input-group-append">
                        <span class="input-group-text">00</span>
                    </div>
                </div>
            </div>

            </div>

            <div class="box">
                <div class="box-footer">
                    <a href="<?php echo e(URL::previous()); ?>" class="btn btn-default">Retroceder</a>
                    <button type="submit" class="btn btn-info pull-right"><i class="fa fa-check-circle"></i> Salvar</button>
                </div>
            </div>
        </div>
    </div>
</div>
</form>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script src="<?php echo e(asset('platform/js/formatarValorMonetario.js')); ?>" type="text/javascript"></script>
<script>

$("#basic-form").validate({

    rules: {
           tipos_saidas_id: {
               required: true,
           },
           valor: {
               required: true,
           },
           descricao: {
               required: true,
               min: 3,
           },


       },
		    errorPlacement:function($,t){
				    $.addClass("help-block"),
					$.insertAfter(t)},
					highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
					unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},

    });
    </script>
     <script type="text/javascript">

         function validaDouble(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;

                    //campo.value = campo.value.replace(/,/gi, ".");

                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                                return false;
                            }
                        }
                    }
                }

        function validaNumeroS(evento, valor) {
            var tecla = (window.evento) ? evento.keyCode : evento.which;
            if ((tecla === 13) || (tecla === 44) || (tecla === 45) || (tecla === 46)) {
                return false;
            }
            else {
                if (tecla === 8 || tecla === 0 || tecla === 45) {
                    return true;
                }
                else {
                    valor += "" + tecla - 48;
                    if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57) {
                        return false;
                    }
                }
            }
        }

        function validaS(campo, evento, valor) {
                    var tecla = (window.evento) ? evento.keyCode : evento.which;



                    if (tecla === 13) {
                        return false;
                    }
                    else {
                        if (tecla === 8 || tecla === 0 || tecla === 45) {
                            return true;
                        }
                        else {
                            valor += "" + tecla - 48;
                            if (tecla !== 44 && tecla !== 46 && tecla < 48 || tecla > 57 || valor < 0) {
                                return false;
                            }
                        }
                    }
                }
</script>

<script>
      //document.getElementById("valor").onblur = function () {
        //this.value = formatarValorMonetario(this.value)

     //   this.value = new Intl.NumberFormat().format(this.value)
    //}

    new Intl.NumberFormat('en-DE').format("valor")

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /mnt/HC_Volume_27524624/proudmin/ngola.proudminds.co.ao/NgolaGestaoIgrejas/resources/views/saida/create.blade.php ENDPATH**/ ?>