

<?php if(session()->has('message')): ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <?php echo session('message'); ?>

    </div>
    <?php endif; ?>

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Utilizadores</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Utilizadores</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Users</h4>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#create1Modal"><i class="fa fa-plus-circle"></i> Adicionar</button>

                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Photo</th>
                                                <th>Nome</th>
                                                <th>Perfil</th>
                                                <th>Email</th>
                                                <th>Data de registo</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Estado</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $v_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->index +1); ?></td>

                                                <td><?php echo e($user->profile_photo_path); ?></td>

                                                <td><?php echo e($user->name); ?></td>

                                                <td><?php echo e($user->role->description); ?></td>

                                                <td><?php echo e($user->email); ?></td>

                                                <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d/m/Y H:i:s')); ?></td>
                                                <td><?php echo e(\Carbon\Carbon::parse($user->updated_at)->format('d/m/Y H:i:s')); ?></td>
                                                <td style="text-align:center;">
                                                    <?php if($user->status==1): ?>
                                                        <small class="label  bg-green">Activo</small>
                                                    <?php else: ?>
                                                        <small class="label  bg-red">Inactivo</small>
                                                    <?php endif; ?>
                                                </td>

                                                <td style="text-align: center;">
                                                    <?php if($user->status==1): ?>
                                                        <button data-toggle="modal" data-target="#updateModal" wire:click="edit(<?php echo e($user->id); ?>)" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                        <button wire:click="restorePassword(<?php echo e($user->id); ?>)" class="btn btn-warning btn-sm"><i class="fa fa-undo"></i></button>

                                                        <?php if(Auth::user()->id != $user->id ): ?>
                                                        <button wire:click="disableUser(<?php echo e($user->id); ?>)" class="btn btn-danger btn-sm"><i class="fa fa-user-times"></i></button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                    <?php echo e($v_users->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>



                 <!-- Modal -->

 <div wire:ignore.self class="modal fade" id="create1Modal" tabindex="-1" role="dialog" aria-labelledby="createModallabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Registar Utilizador</h5>
                <button type="button" class="close" data-dismiss="modal" wire:click.prevent="limpaCampos()"><span>&times;</span>
                </button>
            </div>

            <div class="modal-body">

                <form id="entryForm"  enctype="multipart/form-data" method="POST" action="<?php echo e(route('register')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Perfil<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <select name="role_id" class="form-control" >
                                <option value=""></option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                        <?php $__errorArgs = ['role_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger error"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Nome<span class="text-danger">*</span></label>
                        <div class="col-sm-10">
                            <input name="name" type="text" class="form-control"  placeholder="" value="" >
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger error"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        </div>
                    </div>

                    <div class="form-group row">
                        <label  class="col-sm-2 col-form-label">Email</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="" name="email">
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger error"><?php echo e($message); ?></span><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        </div>
                    </div>

                    <?php if($errors->any()): ?>
                    <ul class="text-danger">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-danger"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default close-btn" data-dismiss="modal"> Cancelar</button>

                    <button type="submit"  wire:submit.prevent="store()" class="btn btn-info close-modal"><i class="fa fa-check"></i> Salvar</button>
                </div>



    </form>

            </div>



        </div>
    </div>
</div>

<?php $__env->startSection('javascript'); ?>



    <script type="text/javascript">
        window.livewire.on('userStoreCl', () => {
            $('#create1Modal').modal('hide');
        });

        window.setTimeout(function(){
            $(".alert-success").fadeTo(1000,0).slideUp(1000, function(){
                $(this).remove();
            });
                    }, 3000);
        window.setTimeout(function(){
            $(".alert-warning").fadeTo(1000,0).slideUp(1000, function(){
            $(this).remove();
                });
        }, 3000);
    </script>

<?php $__env->stopSection(); ?>
<?php /**PATH C:\xampp\htdocs\NgolaGIgrejas\resources\views/livewire/users.blade.php ENDPATH**/ ?>