
<?php echo $__env->make('livewire.user.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if(session()->has('message')): ?>
    <div class="alert alert-success alert-dismissible">
        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
        <?php echo session('message'); ?>

    </div>
    <?php endif; ?>

<!--**********************************
            Content body start
        ***********************************-->

                <div class="row page-titles mx-0">
                    <div class="col-sm-6 p-md-0">
                        <div class="welcome-text">
                            <h4>Ola, Bem-Vindo</h4>
                            <span class="ml-1">Utilizadores</span>
                        </div>
                    </div>
                    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0)">Configurações</a></li>
                            <li class="breadcrumb-item active"><a href="javascript:void(0)">Utilizadores</a></li>
                        </ol>
                    </div>
                </div>
                <!-- row -->

                <div class="row">

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Users</h4>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#createUserModal"><i class="fa fa-plus-circle"></i> Adicionar</button>

                            </div>

                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example" class="display" style="min-width: 845px">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Photo</th>
                                                <th>Nome</th>
                                                <th>Perfil</th>
                                                <th>Email</th>
                                                <th>Data de registo</th>
                                                <th>Data última actualização</th>
                                                <th style="text-align:center;">Estado</th>
                                                <th style="text-align:center;">Operação</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = $v_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->index +1); ?></td>

                                                <td><?php echo e($user->profile_photo_path); ?></td>

                                                <td><?php echo e($user->name); ?></td>

                                                <td><?php echo e($user->role->description); ?></td>

                                                <td><?php echo e($user->email); ?></td>

                                                <td><?php echo e(\Carbon\Carbon::parse($user->created_at)->format('d/m/Y H:i:s')); ?></td>
                                                <td><?php echo e(\Carbon\Carbon::parse($user->updated_at)->format('d/m/Y H:i:s')); ?></td>
                                                <td style="text-align:center;">
                                                    <?php if($user->status==1): ?>
                                                        <small class="label  bg-green">Activo</small>
                                                    <?php else: ?>
                                                        <small class="label  bg-red">Inactivo</small>
                                                    <?php endif; ?>
                                                </td>

                                                <td style="text-align: center;">
                                                    <?php if($user->status==1): ?>
                                                        <button data-toggle="modal" data-target="#updateModal" wire:click="edit(<?php echo e(encrypt($user->id)); ?>)" class="btn btn-info btn-sm"><i class="fa fa-edit"></i></button>
                                                        <button wire:click="restorePassword(<?php echo e(encrypt($user->id)); ?>)" class="btn btn-warning btn-sm"><i class="fa fa-undo"></i></button>

                                                        <?php if(Auth::user()->id != $user->id ): ?>
                                                        <button wire:click="disableUser(<?php echo e(encrypt($user->id)); ?>)" class="btn btn-danger btn-sm"><i class="fa fa-user-times"></i></button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                    <?php echo e($v_users->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>



<?php $__env->startSection('javascript'); ?>



    <script type="text/javascript">
        window.livewire.on('userStoreCl', () => {
            $('#create1Modal').modal('hide');
        });

        window.setTimeout(function(){
            $(".alert-success").fadeTo(1000,0).slideUp(1000, function(){
                $(this).remove();
            });
                    }, 3000);
        window.setTimeout(function(){
            $(".alert-warning").fadeTo(1000,0).slideUp(1000, function(){
            $(this).remove();
                });
        }, 3000);
    </script>

<?php $__env->stopSection(); ?>
<?php /**PATH /mnt/HC_Volume_27524624/proudmin/ngola.proudminds.co.ao/NgolaGestaoIgrejas/resources/views/livewire/users.blade.php ENDPATH**/ ?>