<?php $__env->startSection('title', 'Igrejas/Igreja'); ?>

<?php $__env->startSection('icone-modulo',"fa fa-building"); ?>
<?php $__env->startSection('titulopagina', 'Gestão De Igrejas'); ?>

<?php $__env->startSection('icone','fa fa-houzz'); ?>
<?php $__env->startSection('module','Igrejas/Igreja'); ?>

<?php if(isset($igrejas)): ?>
<?php $__env->startSection('subtitle','Editar'); ?>
<?php else: ?>
<?php $__env->startSection('subtitle','Novo'); ?>
<?php endif; ?>


<?php $__env->startSection('content'); ?>


<div class="row page-titles mx-0">
    <div class="col-sm-6 p-md-0">
        <div class="welcome-text">
            <h4>Ola, Bem-Vindo!</h4>
            <span class="ml-1">Igrejas</span>
        </div>
    </div>
    <div class="col-sm-6 p-md-0 justify-content-sm-end mt-2 mt-sm-0 d-flex">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Igrejas</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Igreja</a></li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-xl-6 col-xxl-12">
            <?php if(isset($igreja)): ?>
                <form  id="entryForm" action="<?php echo e(route('igrejas.update', $igreja->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo method_field('PUT'); ?>
            <?php else: ?>
                <form  id="entryForm" action="<?php echo e(route('igrejas.store')); ?>" method="POST" enctype="multipart/form-data">

                <?php endif; ?>
                <?php echo csrf_field(); ?>


            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-houzz"></i> <?php if(isset($igreja)): ?> Editar <?php else: ?> Registo de <?php endif; ?> Igrejas/Igreja</h3>
                </div>
                <!-- /.box-header -->
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Igreja</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label>Nome</label>
                                                <input type="text" class="form-control"  name="nome" value="<?php echo e($igreja->nome ?? ''); ?>"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Descrição</label>
                                                <input type="text" class="form-control"  name="descricao" value="<?php echo e($igreja->descricao ?? ''); ?>"  maxlength="255" required>
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label>Razão Social</label>
                                                <input type="text" class="form-control"  name="razaoSocial" value="<?php echo e($igreja->razaoSocial ?? ''); ?>"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Categoria</label>
                                                <input type="text" class="form-control"  name="categoria" value="<?php echo e($igreja->categoria ?? ''); ?>"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Email</label>
                                                <input type="text" class="form-control"  name="email" value="<?php echo e($igreja->email ?? ''); ?>"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Endereço</label>
                                                <input type="text" class="form-control"  name="endereco" value="<?php echo e($igreja->endereco ?? ''); ?>"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Contacto</label>
                                                <input type="text" class="form-control"  name="telefone" value="<?php echo e($igreja->telefone ?? ''); ?>"  maxlength="255" required>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Pais</label>
                                                <select class="form-control" name="pais_id" id="country-dropdown">
                                                    <option selected>Escolhe...</option>
                                                    <?php $__currentLoopData = $pais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($pais->id); ?>" >
                                                      <?php echo e($pais->nome); ?>

                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label>Provincia</label>
                                                <select class="form-control" name="provincia_id" id="state-dropdown">


                                                </select>
                                            </div>


                                            <div class="form-group col-md-6">
                                                <label>Municipio</label>
                                                <select id="city-dropdown" class="form-control" name="municipio_id">

                                                </select>
                                            </div>




                                        </div>

                                        <?php if($errors->any()): ?>
                                            <ul class="text-danger">
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="text-danger"><?php echo e($error); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php endif; ?>

                                        <?php $__errorArgs = ['valor'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger">
                                                <?php echo e($message); ?>

                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <a href="<?php echo e(URL::previous()); ?>" class="btn btn-default">Retroceder</a>
                                        <button type="submit" class="btn btn-primary">Salvar</button>

                                </div>
                            </div>
                        </div>


            </div>


        </form>
    </div>
</div>



<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>

<script src="<?php echo e(asset('assets/js/jquery.validate.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/messages_pt_PT.min.js')); ?>"></script>

<script>
    $(document).ready(function() {
    $('#country-dropdown').on('change', function() {
    var pais_id = this.value;
    $("#state-dropdown").html('');
    $.ajax({
    url:"<?php echo e(url('get-states-by-country')); ?>",
    type: "POST",
    data: {
    pais_id: pais_id,
    _token: '<?php echo e(csrf_token()); ?>'
    },
    dataType : 'json',
    success: function(result){
    $('#state-dropdown').html('<option value="">Escolhe a Provincia</option>');
    $.each(result.provincias,function(key,value){
    $("#state-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    $('#city-dropdown').html('<option value="">Escolhe Primeiro a Provincia</option>');
    }
    });
    });
    $('#state-dropdown').on('change', function() {
    var provincia_id = this.value;
    $("#city-dropdown").html('');
    $.ajax({
    url:"<?php echo e(url('get-cities-by-state')); ?>",
    type: "POST",
    data: {
    provincia_id: provincia_id,
    _token: '<?php echo e(csrf_token()); ?>'
    },
    dataType : 'json',
    success: function(result){
    $('#city-dropdown').html('<option value="">Escolhe o Municipio</option>');
    $.each(result.municipios,function(key,value){
    $("#city-dropdown").append('<option value="'+value.id+'">'+value.nome+'</option>');
    });
    }
    });
    });
    });

$("#entryForm").validate({

rules: {
       email: {
           required: true,
           email:true
       },
       nome: {
           required: true

       },
       descricao: {
           required: true

       },
       razaoSocial: {
           required: true

       },
       categoria: {
           required: true

       },
       endereco: {
           required: true

       },
       telefone: {
           required: true

       }

   },




       errorPlacement:function($,t){
           $.addClass("help-block"),
           $.insertAfter(t)},
           highlight:function(t,n,a){$(t).parents(".form-group").addClass("has-error").removeClass("has-success")},
           unhighlight:function(t,n,a){$(t).parents(".form-group").addClass("has-success").removeClass("has-error")},



});

</script>

<?php $__env->stopSection(); ?>








<?php echo $__env->make('layouts.platform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\NgolaGIgrejas\resources\views/igreja/create.blade.php ENDPATH**/ ?>