<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SendMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->from( config('mail.from.contact_address'))
            ->subject('Contacto do Portal')
            ->view('emailResposta.contacto')
            ->with('data', $this->data);
    }
}

// Mail::mailer('contact')->raw('Hello World!', function($msg) {$msg->to('longui@hotmail.com')->subject('Test Email'); });
