CHANGELOG for 2.7.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.7 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.7.0...v2.7.1

* 2.7.8 (2015-12-26)

 * bug #16864 [Yaml] fix indented line handling in folded blocks (xabbuh)
 * bug #17052  Fixed flatten exception recursion with errors (GrahamCampbell)
 * bug #16826 Embedded identifier support (mihai-stancu)
 * bug #17079 Also transform inline mappings to objects (WouterJ)
 * bug #17129 [Config] Fix array sort on normalization in edge case (romainneutron)
 * bug #17094 [Process] More robustness and deterministic tests (nicolas-grekas)
 * bug #17112 [PropertyAccess] Reorder elements array after PropertyPathBuilder::replace (alekitto)
 * bug #16797 [Filesystem] Recursivly widen non-executable directories (Slamdunk)
 * bug #17040 [Console] Avoid extra blank lines when rendering exceptions (ogizanagi)
 * bug #17055 [Security] Verify if a password encoded with bcrypt is no longer than 72 characters (jakzal)
 * bug #16959 [Form] fix #15544 when a collection type attribute "required" is false, "prototype" should too (HeahDude)
 * bug #16860 [Yaml] do not remove "comments" in scalar blocks (xabbuh)
 * bug #17002 [Console][Table] fixed render row that contains multiple cells. (aitboudad)
 * bug #16971 [HttpFoundation] Added the ability of using BinaryFileResponse with stream wrappers (jakzal, Sander-Toonen)
 * bug #17048 Fix the logout path when not using the router (stof)
 * bug #17049 Fix the logout path when not using the router (stof)
 * bug #17057 [FrameworkBundle][HttpKernel] the finder is required to discover bundle commands (xabbuh)
 * bug #17006 [Form] Fix casting regression in DoctrineChoiceLoader (bendavies)
 * bug #16915 [Process] Enhance compatiblity with --enable-sigchild (nicolas-grekas)
 * bug #16829 [FrameworkBundle] prevent cache:clear creating too long paths (Tobion)
 * bug #16921 Fix short array syntax for php 5.3 (ewgRa)
 * bug #16450 [Serializer] Fixed `array_unique` on array of objects in `getAllowedAttributes`. (CornyPhoenix)
 * bug #16757 [FrameworkBundle] [Translation] Fixed translations not written when no translations directory in update command (jeremyFreeAgent)
 * bug #16871 [FrameworkBundle] Disable built-in server commands when Process component is missing (gnugat, xabbuh)
 * bug #16870 [FrameworkBundle] Disable the server:run command when Process component is missing (gnugat, xabbuh)
 * bug #16742 [Console][ProgressBar] redrawFrequency should never be 0 (dritter)
 * bug #16799 Improve error message for undefined DIC aliases (mpdude)
 * bug #16825 [VarDumper] fix .sf-dump z-index (debug bar conflict) (Antoine LA)
 * bug #16772 Refactoring EntityUserProvider::__construct() to not do work, cause cache warm error (weaverryan)
 * bug #16753 [Process] Fix signaling/stopping logic on Windows (nicolas-grekas)
 * bug #16733 [Console] do not encode backslashes in console default description (Tobion)
 * bug #16312 [HttpKernel] clearstatcache() so the Cache sees when a .lck file has been released (mpdude)
 * bug #16351 [WIP] [Form] [TwigBridge] Bootstrap horizontal theme missing tests (pieter2627)
 * bug #16685 [Form] Fixed: Duplicate choice labels are remembered when using "choices_as_values" = false (webmozart)
 * bug #16705 [Form] Deprecated setting "choices_as_values" to "false" (webmozart)
 * bug #16695 [SecurityBundle] disable the init:acl command if ACL is not used (Tobion)
 * bug #16679 [Form] Disabled view data validation if "data_class" is set to null (webmozart)
 * bug #16676 [HttpFoundation] Workaround HHVM rewriting HTTP response line (nicolas-grekas)
 * bug #16668 [ClassLoader] Fix parsing namespace when token_get_all() is missing (nicolas-grekas)
 * bug #16386 Bug #16343 [Router] Too many Routes ? (jelte)
 * bug #16651 [Debug] Ensure class declarations are loaded only once (nicolas-grekas)

* 2.7.7 (2015-11-23)

 * security #16631 CVE-2015-8124: Session Fixation in the "Remember Me" Login Feature (xabbuh)
 * security #16630 CVE-2015-8125: Potential Remote Timing Attack Vulnerability in Security Remember-Me Service (xabbuh)
 * bug #16588 Sent out a status text for unknown HTTP headers. (dawehner)
 * bug #16295 [DependencyInjection] Unescape parameters for all types of injection (Nicofuma)
 * bug #16574 [Process] Fix PhpProcess with phpdbg runtime (nicolas-grekas)
 * bug #16578 [Console] Fix bug in windows detection (kbond)
 * bug #16546 [Serializer] ObjectNormalizer: don't serialize static methods and props (dunglas)
 * bug #16352 Fix the server variables in the router_*.php files (leofeyer)
 * bug #16537 [Validator] Allow an empty path with a non empty fragment or a query (jakzal)
 * bug #16528 [Translation] Add support for Armenian pluralization. (marcosdsanchez)
 * bug #16510 [Process] fix Proccess run with pts enabled (ewgRa)
 * bug #16292 fix race condition at mkdir (#16258) (ewgRa)
 * bug #15945 [Form] trigger deprecation warning when using empty_value (xabbuh)
 * bug #16384 [FrameworkBundle] JsonDescriptor - encode container params only once (xabbuh)
 * bug #16480 [VarDumper] Fix PHP7 type-hints compat (nicolas-grekas)
 * bug #16463 [PropertyAccess] Port of the performance optimization from 2.3 (dunglas)
 * bug #16462 [PropertyAccess] Fix dynamic property accessing. (dunglas)
 * bug #16454 [Serializer] GetSetNormalizer shouldn't set/get static methods (boekkooi)
 * bug #16453 [Serializer] PropertyNormalizer shouldn't set static properties (boekkooi)
 * bug #16471 [VarDumper] Fix casting for ReflectionParameter (nicolas-grekas)
 * bug #16294 [PropertyAccess] Major performance improvement (dunglas)
 * bug #16331 fixed Twig deprecation notices (fabpot)
 * bug #16306 [DoctrineBridge] Fix issue which prevent the profiler to explain a query  (Baachi)
 * bug #16359 Use mb_detect_encoding with $strict = true (nicolas-grekas)
 * bug #16144 [Security] don't allow to install the split Security packages (xabbuh)

* 2.7.6 (2015-10-27)

 * bug #16338 [VarDumper] Fix anonymous class dumping (nicolas-grekas)
 * bug #16288 [Process] Inherit env vars by default in PhpProcess (nicolas-grekas)
 * bug #16302 [DoctrineBridge] Fix required guess of boolean fields (enumag)
 * bug #16298 Changed one console output style to avoid visual issues (javiereguiluz)
 * bug #16291 [VarDumper] Fix return type and anonymous classes dumping (nicolas-grekas)
 * bug #16177 [HttpFoundation] Fixes /0 subnet handling in IpUtils (ultrafez)
 * bug #16262 [TwigBundle] Fix Twig cache is not properly warmed (tucksaun)
 * bug #16259 [Validator] Allow an empty path in a URL with only a fragment or a query (jakzal)
 * bug #16226 [filesystem] makeRelativePath does not work correctly from root (jaytaph, fabpot)
 * bug #16108 [Security] #15764. Use SessionAuthenticationStrategy on RememberMe login (s12v)
 * bug #16196 [Console] Fix progress bar formatting when max is set on start() and some other edge cases (vsychov, fabpot)
 * bug #16183 [VarDumper] Fix wordwrap with Bootstrap (ogizanagi)
 * bug #16182 [Process] Workaround buggy PHP warning (cbj4074)
 * bug #16095 [Console] Add additional ways to detect OS400 platform (johnkary)
 * bug #15793 [Yaml] Allow tabs before comments at the end of a line (superdav42)
 * bug #16152 Fix URL validator failure with empty string (fabpot, bocharsky-bw)
 * bug #15121 fixed #15118 [Filesystem] mirroring a symlink copies absolute file path (danepowell)
 * bug #15161 avoid duplicated path with addPrefix (remicollet)
 * bug #16146 [Security] sync translations and add a test for it (xabbuh)
 * bug #16133 compatibility with Security component split (xabbuh)
 * bug #16123 Command list ordering fix (spdionis, fabpot)
 * bug #14842 [Security][bugfix] "Remember me" cookie cleared on logout with custom "secure"/"httponly" config options  (MacDada)
 * bug #13627 [Security] InMemoryUserProvider now concerns whether user's password is changed when refreshing (issei-m)
 * bug #16090 Fix PropertyAccessor modifying array in object when array key does no… (pierredup)
 * bug #16092 [Process] Throw exception if tempnam returns false (pierredup)
 * bug #16111 Throw exception if tempnam returns false in ProcessPipes (pierredup)
 * bug #16087 Fixing typo in variable name (yceruto)
 * bug #16053 [Console] use PHP_OS instead of php_uname('s') (xabbuh)
 * bug #15860 [Yaml] Fix improper comments removal (ogizanagi)
 * bug #16050 [TwigBundle] fix useless and failing test (Tobion)
 * bug #16028 [DomCrawler] always pass base href to subcrawlers (xabbuh)
 * bug #15482 [Yaml] Improve newline handling in folded scalar blocks (teohhanhui)
 * bug #15976 [Console] do not make the getHelp() method smart (xabbuh)
 * bug #15799 [HttpFoundation] NativeSessionStorage `regenerate` method wrongly sets storage as started (iambrosi)
 * bug #15446 [Twig][Bridge] force space between widget and label in checkbox_radio_label (MatTheCat)
 * bug #15533 [Console] Fix input validation when required arguments are missing (jakzal)
 * bug #15915 Detect Mintty for color support on Windows (stof)
 * bug #15906 Forbid serializing a Crawler (stof)
 * bug #15682 [Form] Added exception when setAutoInitialize() is called when locked (jaytaph)
 * bug #15776 [TwigBridge] fix with_minutes option in time widget (arduanov)
 * bug #15846 [FrameworkBundle] Advanced search templates of bundles (yethee)
 * bug #15895 [Security] Allow user providers to be defined in many files (lyrixx)

* 2.7.5 (2015-09-25)

 * bug #15866 [VarDumper] Fix dump comparison on large arrays (romainneutron)
 * bug #15878 [OptionsResolver] Fix catched exception along the dependency tree mistakenly detects cyclic dependencies (lemoinem)
 * bug #15795 [Console] Default to stderr for the console helpers (2.7+) (alcohol)
 * bug #15821 [EventDispatcher] fix memory leak in getListeners (Tobion)
 * bug #15859 [Config] Fix enum default value in Yaml dumper (romainneutron)
 * bug #15826 [Finder] Optimize the hot-path (nicolas-grekas)
 * bug #15804 [VarDumper] Fix HtmlDumper constructor calling CliDumper's (nicolas-grekas)
 * bug #15802 [Finder] Handle filtering of recursive iterators and use it to skip looping over excluded directories (nicolas-grekas)
 * bug #15803 [Finder] Exclude files based on path before applying the sorting (stof)
 * feature #13761 Automatically process extensions when they implement CompilerPassInterface (WouterJ)
 * bug #13794 [DomCrawler] Invalid uri created from forms if base tag present (danez)
 * bug #15728 Use stderr by default when a specific output is not injected (Seldaek)
 * bug #15637 Use ObjectManager interface instead of EntityManager (gnat42)
 * bug #15783 [Debug] Fix case mismatch detection (nicolas-grekas)
 * bug #14802 [HttpKernel] fix broken multiline <esi:remove> (sstok)
 * bug #14841 [DoctrineBridge] Fixed #14840 (saksmt)
 * bug #15770 [Yaml] Fix the parsing of float keys (jmgq)
 * bug #15771 [Console] Ensure the console output is only detected as decorated when both stderr and stdout support colors (Seldaek)
 * bug #15750 Add tests to the recently added exceptions thrown from YamlFileLoaders (jakzal)
 * bug #15763 [HttpKernel] fix DumpDataCollector compat with Twig 2.0 (nicolas-grekas)
 * bug #15718 Fix that two DirectoryResources with different patterns would be deduplicated (mpdude)
 * bug #15516 [Translator][warmup][fallback locales] fixed missing cache file generation. (aitboudad)
 * bug #14916 [WebProfilerBundle] Added tabindex="-1" to not interfer with normal UX (drAlberT)
 * bug #15725 Dispatch console.terminate *after* console.exception (Seldaek)
 * bug #15731 improve exceptions when parsing malformed files (xabbuh)
 * bug #15737 Fix the injection of the container in invokable controllers (stof)
 * bug #15729 [Kernel] Integer version constants (Tobion)

* 2.7.4 (2015-09-08)

 * bug #15552 [ExpressionLanguage] Fixed expressions cache key generation (inso)
 * bug #15527 [Translator][fallback catalogues] fixed circular reference. (aitboudad)
 * bug #15662 [Form][ Choice type] fixed groups with empty array. (aitboudad)
 * bug #15601 [console] Use the description when no help is available (Nicofuma)
 * bug #15649 [VarDumper] Fix missing support for dumping PHP7 return type (nicolas-grekas)
 * bug #15603 [HttpKernel] Do not normalize the kernel root directory path #15567 (leofeyer)
 * bug #15647 [Debug] Ignore silencing for deprecations (nicolas-grekas)
 * bug #15625 Various fixes esp. on Windows (nicolas-grekas)
 * bug #15428 Fix the validation of form resources to register the default theme (stof)
 * bug #15623 Fix the retrieval of the value with property path when using a loader (stof)
 * bug #15619 [Translation] Fix the string casting in the XliffFileLoader (stof)
 * bug #15575 Add appveyor.yml for C.I. on Windows (nicolas-grekas)
 * bug #15493 [VarDumper] fixed HtmlDumper to target specific the head tag (SaschaDens)
 * bug #15611 [Translation][Xliff Loader] Support omitting the <target> node in an .xlf file. (leofeyer)
 * bug #15608 [Form] Fix the handling of values for multiple choice types (stof)
 * bug #15549 [FrameworkBundle] Fix precedence of xdebug.file_link_format (nicolas-grekas)
 * bug #15589 made Symfony compatible with both Twig 1.x and 2.x (fabpot)
 * bug #15590 Made Symfony 2.7 compatible with Twig 2.0 (fabpot)
 * bug #15535 made Symfony compatible with both Twig 1.x and 2.x (fabpot)
 * bug #15561 [Form] only use PropertyPath if not already callable (Tobion)
 * bug #15588 [WebProfilerBundle] add import for Twig macro (xabbuh)
 * bug #15546 [Form] fixed BC-break on grouped choice lists (origaminal)
 * bug #15515 [Console] Fixed warning when command alias is longer than command name (dosten)
 * bug #15251 [DoctrineBridge][Form] Fix IdReader when indexing by primary foreign key (giosh94mhz)
 * bug #14372 [DoctrineBridge][Form] fix EntityChoiceList when indexing by primary foreign key (giosh94mhz)
 * bug #15514 removed _self usage when not needed (fabpot)
 * bug #15489 Implement the support of timezone objects in the stub IntlDateFormatter (stof)
 * bug #15426 [Serializer] Add support for variadic arguments in the GetSetNormalizer (stof)
 * bug #15480 [Yaml] Nested merge keys (mathroc)
 * bug #15443 [Debug] Enhance DebugClassLoader performance on MacOSX (nicolas-grekas)
 * bug #15445 do not remove space between attributes (greg0ire)
 * bug #15263 [HttpFoundation] fixed the check of 'proxy-revalidate' in Response::mustRevalidate() (axiac)
 * bug #15425 [Routing] Fix the retrieval of the default value for variadic arguments in the annotation loader (wdalmut, stof)
 * bug #15074 Fixing DbalSessionHandler to work with a Oracle "limitation" or bug? (nuncanada)
 * bug #13828 [Validator] Improve Iban Validation (afurculita)
 * bug #15380 do not dump leading backslashes in class names (xabbuh)
 * bug #15376 [ClassMapGenerator] Skip ::class constant (WouterJ)
 * bug #15389 [securityBundle] Compare roles strictly when computing inherited roles (bokonet)
 * bug #15170 [Config] type specific check for emptiness (xabbuh)
 * bug #15411 Fix the handling of null as locale in the stub intl classes (stof)

* 2.7.3 (2015-07-31)

 * bug #15413 Fix the return value on error for intl methods returning arrays (stof)
 * bug #15392 Fix missing _route parameter notice in RouterListener logging case (Haehnchen)
 * bug #15390 [php7] Fix for substr() always returning a string (nicolas-grekas)
 * bug #15386 [php7] Fix for substr() always returning a string (nicolas-grekas)
 * bug #15355 [Security] Do not save the target path in the session for a stateless firewall (lyrixx)
 * bug #15306 [HttpKernel] [HttpCache] Fix deprecated error in HttpCache#getSurrogate (m14t)
 * bug #15369 [TwigBridge] type-dependent path discovery (marcosdsanchez, xabbuh)
 * bug #15361 [Yaml] throw a ParseException on invalid data type (xabbuh)
 * bug #15345 [Twig+FrameworkBundle] Fix forward compat with Form 2.8 (nicolas-grekas)
 * bug #15330 [Console] Fix console output with closed stdout (jakzal)
 * bug #15339 [Serializer] Fix 2 bugs regarding private setters (dunglas)
 * bug #15326 [Security] fix check for empty usernames (xabbuh)
 * bug #15291 [HttpFoundation] Fix Response::closeOutputBuffers() for HHVM 3.3 (nicolas-grekas)
 * bug #15249 [HttpFoundation] [PSR-7] Allow to use resources as content body and to return resources from string content (dunglas)
 * bug #15282 [HttpFoundation] Behaviour change in PHP7 for substr (Nicofuma)
 * bug #15277 [Form] Fix a BC break in the entity (jakzal)
 * bug #15271 fix broken ChoiceQuestion (sstok)
 * bug #15250 [PropertyAccess] BC Break since 2.6.5 (Nicolas Macherey)

* 2.7.2 (2015-07-13)

 * bug #15248 Added 'default' color (jaytaph)
 * bug #15243 Reload the session after regenerating its id (jakzal)
 * bug #15176 [Serializer] Fix ClassMetadata::sleep() (dunglas)
 * bug #15202 [Security] allow to use `method` in XML configs (xabbuh)
 * bug #15218 [Twig][Bridge] replaced `extends` with `use` in bootstrap_3_horizontal_layout.html.twig (MatTheCat)
 * bug #15223 [Finder] Command::addAtIndex() fails with Command instance argument (thunderer)
 * bug #15220 [DependencyInjection] Freeze also FrozenParameterBag::remove (lyrixx)
 * bug #15110 Add a way to reset the singleton (dawehner)
 * bug #15183 [TwigBridge] fix for legacy asset() with EmptyVersionStrategy (xabbuh)
 * bug #15115 [Validator] always evaluate binary format when changed (xabbuh)
 * bug #15163 Update DateTimeToArrayTransformer.php (zhil)
 * bug #15150 [Translation] Azerbaijani language pluralization rule is wrong (shehi)
 * bug #15159  Towards 100% HHVM compat (nicolas-grekas)
 * bug #15146 Towards 100% HHVM compat (nicolas-grekas)
 * bug #15061 [Form] Fixed handling of choices passed in choice groups (webmozart)
 * bug #15145 [Bridge/PhpUnit] Enforce a consistent locale (nicolas-grekas)
 * bug #15069 [Form] Fixed: Data mappers always receive forms indexed by their names (webmozart)
 * bug #15137 [Security] Initialize SwitchUserEvent::targetUser on attemptExitUser (Rvanlaak, xabbuh)
 * bug #15142 Fix choice translation domain for expanded choice widget (jvasseur)
 * bug #15126 [Validator] Fix BC for Validator's validate method (michalmarcinkowski)
 * bug #15101 [Form] Fixed compatibility with FormTypeInterface implementations that don't extend AbstractType (webmozart)
 * bug #15083 [DependencyInjection] Fail when dumping a Definition with no class nor factory (nicolas-grekas)
 * bug #15127 [Validator] fix validation for Maestro UK card numbers (xabbuh)
 * bug #15128 DbalLogger: Small nonutf8 array fix (vpetrovych, weaverryan)
 * bug #15048 [Translation][Form][choice] empty_value shouldn't be translated when it has an empty value (Restless-ET)
 * bug #15117 [Form] fixed sending non array data on submit to ResizeListener (BruceWouaigne)
 * bug #15122 [Console] respect multi-character shortcuts (xabbuh)
 * bug #15012 [Validator] don't trigger deprecation with empty group array (xabbuh)
 * bug #15102 [Translation][debug cmd] fixed failing tests. (aitboudad)
 * bug #13750 [DependencyInjection] Fixed decoration of service for service with parent (hason)
 * bug #15086 Fixed the regexp for the validator of Maestro-based credit/debit cards (javiereguiluz)
 * bug #15058 [Console] Fix STDERR output text on IBM iSeries OS400 (johnkary)
 * bug #14853 [Validator] more strict e-mail validation regex (xabbuh)
 * bug #15064 [Form] Fixed: Support objects with __toString() in choice groups (webmozart)
 * bug #15065 [Form] Fixed: remove quoted strings from Intl date formats (e.g. es_ES full pattern) (webmozart)
 * bug #15039 [Translation][update cmd] taken account into bundle overrides path. (aitboudad)
 * bug #15038 [Translation][debug cmd] taken account into bundle overrides path. (aitboudad)
 * bug #14964 [bugfix][MonologBridge] WebProcessor: passing $extraFields to BaseWebProcessor (MacDada)
 * bug #14989 [FrameworkBundle] Reuse PropertyAccessor service for ObjectNormalizer (dunglas)
 * bug #15036 [VarDumper] Fix dump output for better readability (nicolas-grekas)
 * bug #15031 [PhpUnitBridge] Enforce @-silencing of deprecation notices according to new policy (nicolas-grekas)
 * bug #15027 [Form] Fixed: Filter non-integers when selecting entities by int ID (webmozart, nicolas-grekas)
 * bug #15000 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas)
 * bug #14999 [Debug] Fix fatal-errors handling on HHVM (nicolas-grekas, digitalkaoz)
 * bug #14959 [Debug+VarDumper] Fix handling of PHP7 "Throwable" exceptions (nicolas-grekas)
 * bug #15010 [Debug] Fix log level of stacked errors (nicolas-grekas)
 * bug #15017 [VarDumper] Fix uninitialized id in HtmlDumper (nicolas-grekas)
 * bug #14980 Fixed fluent interface (jaytaph)
 * bug #14974 [Security][Translation] #14920 update translations (vincentaubert)
 * bug #14950 [Form] Fixed: Filter non-integers when selecting entities by int ID (webmozart)
 * bug #14930 Bug #14836 [HttpFoundation] Moves default JSON encoding assignment fr… (Incognito)

* 2.7.1 (2015-06-11)

 * bug #14835 [DependencyInjection] Fixed resolving of service configurators containing Definition objects (webmozart)
 * bug #14816 [TwigBridge] Make AppVariable check if security.context exists (ogizanagi)
 * bug #14897  Allow new lines in Messages translated with transchoice() (replacement for #14867)  (azine)
 * bug #14887 [Form] Swap new ChoiceView constructor arguments to ease migrating from the deprecated one (nicolas-grekas)
 * bug #14900 Silence deprecation warnings by default (reecefowell)
 * bug #14739 [Console] SymfonyStyle : fix blocks wordwrapping (ogizanagi)
 * bug #14740 [Console] SymfonyStyle : fix blocks output is broken on windows cmd (ogizanagi)
 * bug #14623 [Console] SymfonyStyle : fix & automate block gaps. (ogizanagi)
 * bug #14895 [Form] Support DateTimeImmutable in transform() (c960657)
 * bug #14891 without this change allways the legacy code get called (dominikzogg)
 * bug #14888 [Console] Fix ask and askHidden methods (dosten)
 * bug #14705 [Translator] avoid serialize unserializable resources. (aitboudad)
 * bug #14846 [console][TableCell] get cell width without decoration. (aitboudad)
 * bug #14852 [VarDumper] Fix generic casters calling order (nicolas-grekas)
 * bug #14855 [VarDumper] Changed tooltip to expand-all keybinding in OS X (taylankasap)
 * bug #14854 [Bridge\PhpUnit] Fix composer installed phpunit detection (nicolas-grekas)
 * bug #14859 Improve the config validation in TwigBundle (stof)
 * bug #14837 [SecurityBundle] Remove SecurityContext from Compile (Zander Baldwin)
 * bug #14793 [FrameworkBundle] make `templating.helper.router` service available again for BC reasons (xabbuh)
 * bug #14785 [BrowserKit] Fix bug when uri starts with http. (amouhzi)
 * bug #14807 [Security][Acl] enforce string identifiers (xabbuh)
 * bug #14808 [WebProfilerBundle][logger] added missing deprecation message. (aitboudad)

* 2.7.0 (2015-05-30)

 * bug #14777 Avoid using the app global variable in the profiler templates (stof)
 * bug #14262 [REVERTED] [TwigBundle] Refresh twig paths when resources change. (aitboudad)
 * security #14759 CVE-2015-4050 [HttpKernel] Do not call the FragmentListener if _controller is already defined (jakzal)
 * bug #14745 [Serializer] AbstractNormalizer::instantiateObject allow default values when not optional (boekkooi)
 * bug #14743 [DebugBundle] Fix config XSD (nicolas-grekas)
 * bug #14711 [Serializer] AbstractNormalizer instantiateObject avoid `null` rejection (boekkooi)
 * bug #14726 [Translation] fixed JSON loader on PHP 7 when file is empty (fabpot)
 * bug #14715 [Form] Check instance of FormBuilderInterface instead of FormBuilder (dosten)
 * bug #14654 [Console] SymfonyStyle : fix blocks failed when $messages is null (ogizanagi)
 * bug #14708 [TwigBridge] use proper class to fetch asset version strategy property (xabbuh)
 * bug #14678 [Security] AbstractRememberMeServices::encodeCookie() validates cookie parts (MacDada)
 * bug #14635 [HttpKernel] Handle an array vary header in the http cache store (jakzal)
 * bug #14513 [console][formater] allow format toString object. (aitboudad)
 * bug #14335 [HttpFoundation] Fix baseUrl when script filename is contained in pathInfo (danez)
 * bug #14593 [Security][Firewall] Avoid redirection to XHR URIs (asiragusa)
 * bug #14576 [DoctrineBridge][Form] Fix BC break in DoctrineType (malarzm)
 * bug #14551 [Form] Fixed ChoiceType with legacy ChoiceList (xelaris)
 * bug #14648 [Console] Fix first choice was invalid when using value (ogizanagi)
 * bug #14618 [DomCrawler] Throw an exception if a form field path is incomplete (jakzal)
 * bug #14699  Fix HTML escaping of to-source links (amenk, nicolas-grekas)
 * bug #14698  Fix HTML escaping of to-source links (nicolas-grekas)
 * bug #14690 [HttpFoundation] IpUtils::checkIp4() should allow `/0` networks (zerkms)
 * bug #14696 Fix the rendering of deprecation log messages (stof)
 * bug #14683 Fixed the indentation in the compiled template for the DumpNode (stof)
 * bug #14262 [TwigBundle] Refresh twig paths when resources change. (aitboudad)
 * bug #13633 [ServerBag] Handled bearer authorization header in REDIRECT_ form (Lance0312)
 * bug #13637 [CSS] WebProfiler break words (nicovak)
 * bug #14217 [WebProfilerBundle] Fix regexp (romqin)
 * bug #14644 [Bridge\Twig] Adding a space between the icon and the error message (zmikael, nicolas-grekas)
 * bug #14645 [WebProfilerBundle] Fix compatiblity with HttpKernel < 2.7 (GromNaN)
 * bug #14640 [DebugBundle] Allow alternative destination for dumps (nicolas-grekas)
 * bug #14600 [Console] SymfonyStyle: fix block rpadding when escaping '<' (ogizanagi)
 * bug #14633 [EventDispatcher] make listeners removable from an executed listener (xabbuh)

* 2.7.0-BETA2 (2015-05-13)

 * bug #14609 [DebugBundle] Remove inlined dumps on XHR (nicolas-grekas)
 * bug #14605 [PropertyAccess] Fix setting public property on a class having a magic getter (lolautruche)
 * bug #14266 [HttpKernel] Check if "symfony/proxy-manager-bridge" package is installed (hason)
 * bug #14465 [Form] Fixed regression: Empty values were not accepted anymore for collapsed, optional choice fields (webmozart)
 * bug #14478 [DebugBundle] Fix dump() output in API / No-Toolbar context (nicolas-grekas)
 * bug #14501 [ProxyBridge] Fix proxy classnames generation (xphere)
 * bug #14540 [Serializer] Ignore \Traversable in default normalizers. (dunglas)
 * bug #14527 Fix getOrigin (WouterJ)
 * bug #14395 [Validator] Property paths starting with 0 are broken. (fago)
 * feature #14472 [Debug] Trigger deprecation notices when using PHP7 reserved class names (nicolas-grekas)
 * bug #14498 [FrameworkBundle] Added missing log in server:run command (lyrixx)
 * bug #14503 [Finder] Only use GLOB_BRACE when available (dosten)
 * bug #14484 [SecurityBundle][WebProfiler] check authenticated user by tokenClass instead of username. (aitboudad)
 * bug #14497 [HttpFoundation] Allow curly braces in trusted host patterns (sgrodzicki)
 * bug #14480 [TwigBundle] Fix deprecated use of FlattenException (alOneh)
 * bug #14469 [Debug] BaseException compatibility for PHP7 (nicolas-grekas)
 * bug #14483 [VarDumper] Fix #14481 : Open tree recursively on OSX (romainneutron)
 * bug #14466 [WebProfiler] fix html syntax for input types (Tobion)
 * bug #14436 Show a better error when the port is in use (dosten)
 * bug #14463 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14415 [Serializer] Fix a bug when using groups together with a name converter (dunglas)
 * bug #14301 [FrameworkBundle][Translation] skip warmUp when cache is not used. (aitboudad)
 * bug #14446 [DependencyInjection] resolve circular reference (xabbuh)
 * feature #14187 [Serializer] Supports hassers and setters for groups annotations (dunglas)
 * feature #14462 Revert "[HttpKernel] Throw a LogicException when kernel.exception does not led to a Response" (nicolas-grekas)
 * bug #14448 [Validator] Fixed Choice when an empty array is used in the "choices" option (webmozart)
 * bug #14451 [Debug] Fix ClassNotFoundFatalErrorHandler candidates lookups (nicolas-grekas)
 * bug #14422 Update DebugClassLoader.php (userfriendly)
 * bug #14419 inject asset packages in assets helper service (xabbuh)
 * bug #14355 [EventDispatcher] make listeners removable from an executed listener (xabbuh)
 * bug #14397 [Debug] Map PHP errors to LogLevel::CRITICAL (nicolas-grekas)
 * bug #14402 [FrameworkBundle][Translation] Check for 'xlf' instead of 'xliff' (xelaris)
 * bug #14272 [FrameworkBundle] Workaround php -S ignoring auto_prepend_file (nicolas-grekas)
 * bug #14362 [Debug] Scream as LogLevel::DEBUG (but for fatal errors / uncaught exceptions) (nicolas-grekas)
 * bug #14345 [FrameworkBundle] Fix Routing\DelegatingLoader resiliency to fatal errors (nicolas-grekas)
 * bug #14381 [FrameworkBundle] Initialize translator with the default locale. (aitboudad)
 * bug #14325 [Routing][DependencyInjection] Support .yaml extension in YAML loaders (thunderer)
 * bug #14344 [Translation][fixed test] refresh cache when resources are no longer fresh. (aitboudad)
 * bug #14346  [WebProfilerBundle] Fix resiliency to exceptions thrown by the url generator (nicolas-grekas)
 * bug #14338 [FrameworkBundle] improve usage of Table helper (xabbuh)
 * bug #14315 [Translation] Revert inlining fallback catalogues as it might cause inconsistent results when a cache is used (mpdude)
 * bug #14129 [FrameworkBundle] Fixed server:start --router relative path issue #14124 (abulford)
 * bug #14313 [HttpKernel] fixed a regression when no exception listeners are registered (fabpot)
 * bug #14268 [Translator] Cache does not take fallback locales into consideration (sf2.3) (mpdude)

* 2.7.0-BETA1 (2015-04-10)

 * feature #14229 [WebProfilerBundle] AJAX links (romqin)
 * feature #13220 [Console] Made output docopt compatible (WouterJ)
 * feature #14178 [Config] Delegate creation of ConfigCache instances to a factory. (mpdude)
 * feature #13443 [Translation][Command][FrameworkBundle] Enable translation debugging in directories (xelaris)
 * feature #14198 Automatically start server:run if server:start failed (WouterJ)
 * feature #13651 [Form][choice] added choice_translation_domain to avoid trans options. (aitboudad)
 * feature #14185 [Translation][Profiler]added the number of times a translation has been used. (aitboudad)
 * feature #13717 Deprecated precision option in favor of scale (WouterJ)
 * feature #14159 [Debug] Add symfony_debug_backtrace() and use it when dealing with fatal errors (jpauli, nicolas-grekas)
 * feature #14192 [HttpKernel] Embed the original exception as previous to bounced exceptions (nicolas-grekas)
 * feature #13626 [WebProfilerBundle] Added feedback about the current symfony version (WouterJ)
 * feature #13554 [TwigBundle] make date formats and number formats configurable (xabbuh)
 * feature #14196 Tweaked some console command styles (javiereguiluz)
 * feature #14181 [Debug] Updated the default log level when a PHP error occurs (lyrixx)
 * feature #14186 [Debug] Renamed "context" key to "scope_vars" to avoid any ambiguity (lyrixx)
 * feature #13942 [Translation] generate translation cache at warmup (xavierleune)
 * feature #14116 [FrameworkBundle] Move lint commands to lint namespace. (aitboudad)
 * feature #14052 [FrameworkBundle] added a protected shortcut getParameter() method in the base Controller class. (hhamon)
 * feature #14080 [VarDumper] Add casters for Reflection* classes (nicolas-grekas)
 * feature #14050 [Form] Refactored choice lists to support dynamic label, value, index and attribute generation (webmozart)
 * feature #14079 [VarDumper] Add and use Caster::PREFIX_* consts (nicolas-grekas)
 * feature #14057 [RFC][Console] Added console style guide helpers (v2) (kbond)
 * feature #14077 [VarDumper] Add VarDumperTestCase and related trait (nicolas-grekas)
 * feature #14058 [VarDumper] Add filters to casters (nicolas-grekas)
 * feature #14003 [Translation][Profiler] Added a Translation profiler. (aitboudad)
 * feature #14002 [Translation][Extractor] Allow extracting an array of files besides extracting a directory (marcosdsanchez)
 * feature #13438 [Console][Table] Add support for colspan/rowspan + multiple header lines (aitboudad)
 * feature #14071  	[VarDumper] Ctrl+click toggles-all and fix IE8 support (larsborn, nicolas-grekas)
 * feature #13981 [Translation] merge all fallback catalogues messages into current catalo... (aitboudad)
 * feature #14006 [VarDumper] with-er interface for Cloner\Data (nicolas-grekas)
 * feature #14034 [VarDumper] add caster for MongoCursor objects (nicolas-grekas)
 * feature #14030 [DependencyInjection] make it possible to dump inlined services to XML (xabbuh)
 * feature #14016   Remove the API version in the validator component (saro0h, fabpot, stof)
 * feature #13960 [VarDumper] Add Caster for XML-parser resources (nicolas-grekas)
 * feature #13937 [FrameworkBundle] Allow to disable Kernel reboot (sroze)
 * feature #13892 [DependencyInjection] Improved yaml syntax (hason)
 * feature #14000 [SECURITY][ACL] fixed Base ACL exceptions on the RuntimeException (Neophy7e)
 * feature #14001  [Security] [ACL] Improved MaskBuilder and PermissionMap (AlexDpy)
 * feature #13959 [VarDumper] Add catch-all-objects hook for casters (nicolas-grekas)
 * feature #13980 [VarDumper] Added support for amqp (lyrixx)
 * feature #12818 [SecurityBundle] Added a command to encode a password (saro0h)
 * feature #13107 [FrameworkBundle] Serializer groups support (dunglas)
 * feature #13872 [FrameworkBundle] Added domain column when debugging translations (hiddewie)
 * feature #13780 [HttpKernel] Throw a LogicException when kernel.exception does not lead to a Response (nicolas-grekas)
 * feature #13897 [translation][performances] move loading resources into Translator initialize. (aitboudad)
 * feature #13864 Entity type: loader caching by query builder instance (dominikzogg)
 * feature #13855 Read validation contraints from Resources/config/validation/ sub-dir (GromNaN)
 * feature #13257 [Serializer] ObjectNormalizer (dunglas)
 * feature #13795 [Serializer] Refactoring of metadata (dunglas)
 * feature #13840 [WebProfilerBundle] Update ajax calls in toolbar to add the css error class (rubenrua)
 * feature #13809 [OptionsResolver] add missing deprecation triggers (Tobion)
 * feature #13398 [PhpUnit] new PhpUnit bridge (nicolas-grekas)
 * feature #13615 [FrameworkBundle] Made ServerParams a service (rpg600)
 * feature #12526 Add an auto_alias compiler pass (Daniel Wehner)
 * feature #13665 [Debug] generalize deprecated interfaces tracking (nicolas-grekas)
 * feature #13656 removed Propel bridge from Symfony Core (fabpot)
 * feature #13500 [Serializer] Normalizers can serialize collections and scalars (dunglas)
 * feature #13463 [WebProfilerBundle] Replaced raster PNG icons with vector SVG icons (sgrodzicki)
 * feature #13234 [Asset] added the component (fabpot)
 * feature #11379 Added new Forwarded header support for Request::getClientIps (tony-co)
 * feature #9782 [Security] added string representation for core Users (tobiassjosten)
 * feature #12174 [TwigBundle] Add loader priority (wizhippo)
 * feature #13074 [Translation] Refresh catalogues when resources change (iamluc)
 * feature #13294 [PropertyAccess] Show property path in all exception messages (mpajunen)
 * feature #13548 [TwigBridge] Added support for passing more files to twig:lint command (sustmi)
 * feature #13120 [Serializer] Name converter support (dunglas)
 * feature #13428 Added a Twig profiler (fabpot)
 * feature #11129 Added i18n support to ConfirmationQuestion (WouterJ)
 * feature #13034 [HttpKernel] [WebProfilerBundle] added HTTP status to profiler search result (xelaris)
 * feature #13475 [SecurityBundle] decouple the logout PHP helper and Twig extension (fabpot)
 * feature #12891 [Form] Deprecated setDefaultOptions() in favor of configureOptions() (peterrehm)
 * feature #13342 [security] Fetching current stored context when not explicitly specified (jaytaph)
 * feature #12960 [FrameworkBundle] Container parameters in Route#condition (nikita2206)
 * feature #13418 [DX] Attempt to improve logging messages with  parameters (iltar)
 * feature #13320 [HttpKernel] Add request uri to Logger context (Rvanlaak)
 * feature #13401 [TwigBundle] use the new Twig autoescaping strategy (fabpot)
 * feature #13361 [Routing] apply deprecation triggers and fix tests (Tobion)
 * feature #13378 lazy-load fragment renderers (fabpot)
 * feature #13354 Twig decoupling from Templating (fabpot)
 * feature #13264 URL manipulations as a Twig extension (fabpot)
 * feature #13289 [DependencyInjection] deprecated synchronized services (fabpot)
 * feature #13323 [Security] removed usage of the deprecated SecurityContextInterface (fabpot)
 * feature #13241 [Form] add back model_timezone and view_timezone options (xabbuh)
 * feature #13252 [Serializer] Refactoring and object_to_populate support. (dunglas)
 * feature #13255 [Serializer] Add circular reference handling to the PropertyNormalizer (dunglas)
 * feature #13259 Deprecate the translator implementation in the Validator component (stof)
 * feature #12956 [Validator] Added checkDNS option on URL validator (saro0h)
 * feature #13230 [TwigBundle] removed the Container dependency on ActionsExtension (fabpot)
 * feature #12602 Add type aliases for allowed types in OptionsResolver (henrikbjorn)
 * feature #12594 [DX] [HttpKernel] Use "context" argument when logging route in RouterListener (iltar)
 * feature #12653 [Filesystem] Keep executable permission when a file is copied (joelwurtz)
 * feature #13164 [Debug] track and report deprecated classes and interfaces (nicolas-grekas)
 * feature #13157 [Security] Updated ACL generateSql.php (jaytaph)
 * feature #13105 [FrameworkBundle] added a test router for the built-in web server (fabpot)
 * feature #12092 [Serializer] Serialization groups support (dunglas)
 * feature #13031 [Serializer] Add xml_format_output context option. Close #12517. (dunglas)
 * feature #12862 [Console] Allowing the user answering key or value of the autocompleterValues (saro0h)
 * feature #12469 [Security] Added the triggering of the security.interactive_login event in SimplePreAuthenticationListener (saro0h)
 * feature #12896 [DX][Profiler] Show the inherited roles in the web profiler (peterrehm)
 * feature #12295 [FrameworkBundle] make GetSetMethodNormalizer available by default (dunglas)
 * feature #12666 [Hackday][Stopwatch] added __toString on StopwatchEvent (damienalexandre)

