<?php
/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2019 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo and "Supercharged by SuiteCRM" logo. If the display of the logos is not
 * reasonably feasible for technical reasons, the Appropriate Legal Notices must
 * display the words "Powered by SugarCRM" and "Supercharged by SuiteCRM".
 */

if (!defined('sugarEntry') || !sugarEntry) {
    die('Not A Valid Entry Point');
}

$mod_strings = array(
    'LBL_BASIC' => 'Einfach',
    'LBL_BASIC_SEARCH' => 'Schnellfilter',
    'LBL_ADVANCED_SEARCH' => 'Erweiterter Filter',
    'LBL_BASIC_TYPE' => 'Basis Typ',
    'LBL_ADVANCED_TYPE' => 'Erweiterter Typ',
    'LBL_SYSOPTS_2' => 'Welcher Datenbanktyp wird für die SuiteCRM-Instanz verwendet, die Sie im Begriff sind zu installieren?',
    'LBL_SYSOPTS_DB' => 'Datenbanktyp festlegen',
    'LBL_SYSOPTS_DB_TITLE' => 'Datenbanktyp',
    'LBL_SYSOPTS_ERRS_TITLE' => 'Bitte beheben Sie die folgenden Fehler bevor Sie fortfahren:',
    'ERR_DB_VERSION_FAILURE' => 'Die Datenbankversion kann nicht geprüft werden.',
    'DEFAULT_CHARSET' => 'UTF-8',
    'ERR_ADMIN_USER_NAME_BLANK' => 'Geben Sie den Benutzernamen für den SuiteCRM Administratorenbenutzer ein. ',
    'ERR_ADMIN_PASS_BLANK' => 'Geben Sie ein Passwort für den Admin Benutzer ein.',
    'LBL_EMPTY' => 'Leer',

    'ERR_CHECKSYS' => 'Während der Kompatibilitätsprüfung sind Fehler festgestellt worden. Um sicherzustellen, dass Ihre SuiteCRM-Installation korrekt funktioniert, leiten Sie Maßnahmen ein, um die unten aufgeführten Probleme zu beheben und drücken Sie den "Erneut Prüfen"-Button oder versuchen Sie eine Neuinstallation.',
    'ERR_CHECKSYS_CALL_TIME' => '"allow_call_time_pass_reference" ist aktiviert (dies sollte in php.ini auf Off gesetzt werden)',
    'ERR_CHECKSYS_CURL' => 'Nicht gefunden: SuiteCRM Scheduler arbeitet mit eingeschränkter Funktionalität.',
    'ERR_CHECKSYS_IMAP' => 'Nicht gefunden: Eingehende E-Mail und Kampagnen (E-Mails) benötigen die IMAP Bibliotheken. Beide werden nicht funktionieren.',
    'ERR_CHECKSYS_MEM_LIMIT_1' => '(Setzen Sie es auf',
    'ERR_CHECKSYS_MEM_LIMIT_2' => 'M oder höher in Ihrer php.ini Datei)',
    'ERR_CHECKSYS_NOT_WRITABLE' => 'Warnung: Keine Schreibrechte',
    'ERR_CHECKSYS_PHP_INVALID_VER' => 'Ihre PHP Version wird nicht unterstützt. Sie müssen eine kompatible Version installieren. Bitte überprüfen Sie dazu die Kompatibilitätsmatrix in den Release Notes. Ihre Version ist',
    'ERR_CHECKSYS_IIS_INVALID_VER' => 'Ihre IIS Version wird nicht unterstützt. Sie müssen eine kompatible Version installieren. Bitte überprüfen Sie dazu die Kompatibilitätsmatrix in den Release Notes. Ihre Version ist ',
    'ERR_CHECKSYS_FASTCGI' => 'Wir haben festgestellt dass Sie kein FastCGI für PHP benutzen. Sie müssen eine kompatible Version installieren. Bitte überprüfen Sie dazu die Kompatibilitätsmatrix in den Release Notes. Bitte beachten Sie auch <a href="http://www.iis.net/php/" target="_blank">http://www.iis.net/php/</a> für weitere Details',
    'ERR_CHECKSYS_FASTCGI_LOGGING' => 'Für optimales Funktionieren bei der Verwendung von IIS/FastCGI sapi, setzen Sie fastcgi.logging in Ihrer php.ini Datei auf 0.',
    'LBL_DB_UNAVAILABLE' => 'Datenbank unerreichbar',
    'LBL_CHECKSYS_DB_SUPPORT_NOT_AVAILABLE' => 'Datenbank Unterstützung wurde nicht gefunden. Bitte stellen Sie sicher, dass Sie die Treiber für eine der folgenden unterstützten Datenbanken installiert haben: MySQL oder MS SQLServer. In Abhängigkeit Ihrer PHP Version müssen Sie entweder die entsprechenden extensions in der php.ini aktivieren oder mit den richtigen Zusätzen re-kompilieren. Bitte konsultieren Sie Ihr PHP Handbuch für mehr Information zum Thema Datenbankunterstützung.',
    'LBL_CHECKSYS_XML_NOT_AVAILABLE' => 'Benötigte Funktionen im Zusammenhang mit den XML Parser Bibliotheken wurden nicht gefunden. In Abhängigkeit Ihrer PHP Version müssen Sie entweder die entsprechenden extensions in der php.ini deaktivieren oder mit den richtigen Zusätzen re-kompilieren. Bitte konsultieren Sie Ihr PHP Handbuch für mehr Information zum diesem Thema."',
    'ERR_CHECKSYS_MBSTRING' => 'Benötigte Funktionen im Zusammenhang mit der Multibyte Strings PHP extension (mbstring) wurden nicht gefunden <br/><br/>Normalerweise ist dieses Modul in PHP nicht aktiviert und muss mit --enable-mbstring kompiliert werden. Für weitere Informationen lesen Sie bitte Ihre PHP Dokumentation durch.',
    'ERR_CHECKSYS_CONFIG_NOT_WRITABLE' => 'Die Konfigurationsdatei existiert bereits, ist aber nicht beschreibbar. Bitte ergreifen Sie die notwendigen Schritte, um die Datei beschreibbar zu machen.',
    'ERR_CHECKSYS_CONFIG_NOT_FOUND' => 'Ihre config.php existiert nicht. Die Datei wird bei der Installation erstellt.',
    'ERR_CHECKSYS_CONFIG_OVERRIDE_NOT_WRITABLE' => 'The config override file exists but is not writeable. Please take the necessary steps to make the file writeable. ',
    'ERR_CHECKSYS_CUSTOM_NOT_WRITABLE' => 'The Custom Directory exists but is not writeable. Please take the necessary steps to make the file writeable.',
    'ERR_CHECKSYS_FILES_NOT_WRITABLE' => "The files or directories listed above are not writeable or are missing and cannot be created. Please take the necessary steps to make the directories writeable.",
    'ERR_CHECKSYS_LOGS_NOT_WRITABLE' => 'The Logs Directory is currently not writable',
    'ERR_CHECKSYS_CACHE_NOT_WRITABLE' => 'The Cache Directory is currently not writable',
    'ERR_CHECKSYS_EXTENSIONS_NOT_WRITABLE' => 'The Extensions Directory is currently not writable',
    'ERR_CHECKSYS_SECRETS_NOT_WRITABLE' => 'The config/secrets directory is currently not writable',
    'ERR_CHECKSYS_ENV_NOT_WRITABLE' => 'The .env file or the directory it is in is not writable.',
    'ERR_CHECKSYS_JSON_NOT_AVAILABLE' => "Funktionen, die mit JSON-Parser-Bibliotheken verknüpft sind und von der SuiteCRM-Anwendung benötigt werden, wurden nicht gefunden. Möglicherweise müssen Sie die Erweiterung in der Datei php.ini einkommentieren oder rekompilieren Sie je nach PHP-Version mit der richtigen Binärdatei. Bitte konsultieren Sie dazu ihre PHP Anleitung für mehr Informationen.",
    'LBL_CHECKSYS_OVERRIDE_CONFIG' => 'Config überschreiben',
    'ERR_CHECKSYS_SAFE_MODE' => 'Safe Mode ist aktiv (kann in der php.ini deaktiviert werden)',
    'ERR_CHECKSYS_ZLIB' => 'ZLib Unterstützung nicht gefunden: SuiteCRM gewinnt einen enormen Leistungsvorteil mit der zlib-Kompression.',
    'ERR_CHECKSYS_ZIP' => 'ZIP-Unterstützung nicht gefunden: SuiteCRM benötigt ZIP Unterstützung um komprimierte Dateien zu verarbeiten.',
    'ERR_CHECKSYS_PCRE' => 'PCRE Bibliothek nicht gefunden: SuiteCRM benötigt die PCRE Bibliothek um Perls reguläre Ausdrücke verarbeiten zu können.',
    'ERR_CHECKSYS_PCRE_VER' => 'PCRE Bibliotheksversion: SuiteCRM benötigt die PCRE Bibliothek 7.0 oder höher um Perls reguläre Ausdrücke verarbeiten zu können.',
    'ERR_DB_ADMIN' => 'Der Datenbank Admin Benutzername und/oder das Passwort ist falsch - es konnte keine Verbindung zur Datenbank hergestellt werden. (Fehler:',
    'ERR_DB_ADMIN_MSSQL' => 'Der Datenbank Admin Benutzername und/oder das Passwort ist falsch - es konnte keine Verbindung zur Datenbank hergestellt werden. Bitte geben Sie einen gültigen Benutzernamen / Passwort ein.',
    'ERR_DB_EXISTS_NOT' => 'Die angegebene Datenbank existiert nicht.',
    'ERR_DB_EXISTS_WITH_CONFIG' => 'Die Datenbank existiert bereits mit Konfigurationsdaten. Um eine Installation mit der gewünschten Datenbank durchzuführen, starten Sie Installation neu und wählen Sie: Verwerfen und Neuerstellen existierender SuiteCRM Tabellen?" Um zu aktualisieren, benutzen Sie den Aktualisierungsassistent im Admin Bereich. Bitte lesen Sie die Dokumentation zum Thema Aktualisierung: <a href="https://docs.suitecrm.com/admin/installation-guide/upgrading/" target="_new">hier</a>.".',
    'ERR_DB_EXISTS' => 'Eine Datenbank mit dem Namen existiert bereits -- es kann keine zweite mit dem gleichen Namen erstellt werden.',
    'ERR_DB_EXISTS_PROCEED' => 'Der Datenbankname existiert bereits. Sie können<br>1.  zurückgehen und einen anderen Namen wählen <br>2.  auf Weiter drücken und fortfahren, allerdings werden dann alle bereits bestehenden Tabellen gelöscht<strong>Dies bedeutet, dass Ihre Tabellen für immer verloren gehen.</strong>',
    'ERR_DB_HOSTNAME' => 'Der Hostname darf nicht leer sein.',
    'ERR_DB_INVALID' => 'Ungültiger Datenbanktyp ausgewählt.',
    'ERR_DB_LOGIN_FAILURE_SHORT' => 'Datenbankverbindungsfehler: Der angegebene Hostname, Port, Benutzername und/oder Passwort ist ungültig.',
    'ERR_DB_LOGIN_FAILURE' => 'Die Host Angabe, der Datenbank Benutzername und/oder das Passwort ist falsch - es konnte keine Verbindung zur Datenbank hergestellt werden. Bitte geben Sie einen gültigen Host, Benutzernamen und/oder Passwort ein.',
    'ERR_DB_LOGIN_FAILURE_MYSQL' => 'Die Host Angabe, der Datenbank Benutzername und/oder das Passwort ist falsch - es konnte keine Verbindung zur Datenbank hergestellt werden. Bitte geben Sie einen gültigen Host, Benutzernamen und/oder Passwort ein.',
    'ERR_DB_LOGIN_FAILURE_MSSQL' => 'Die Host Angabe, der Datenbank Benutzername und/oder das Passwort ist falsch - es konnte keine Verbindung zur Datenbank hergestellt werden. Bitte geben Sie einen gültigen Host, Benutzernamen und/oder Passwort ein.',
    'ERR_DB_MYSQL_VERSION' => 'Ihre MySQL Version (%s) wird von SuiteCRM nicht unterstützt. Sie müssen eine kompatible Version installieren. Bitte überprüfen Sie dazu die Kompatibilitätsmatrix in den Release Notes.',
    'ERR_DB_NAME' => 'Der Name der Datenbank darf nicht leer sein.',
    'ERR_DB_MYSQL_DB_NAME_INVALID' => "Der Datenbankname darf keine Sonderzeichen enthalten",
    'ERR_DB_MSSQL_DB_NAME_INVALID' => "Datenbanknamen können nicht mit einer Zahl, '#' oder '@' beginnen und können keine Leerzeichen sowie folgende Zeichen nicht enthalten: '\"','\", '*', '/', '', '?', ':', '<', '>', '&', '!', oder '-'.\"",
    'ERR_DB_OCI8_DB_NAME_INVALID' => "Datenbanknamen dürfen nur aus alphanumerischen Zeichen und den Symbolen '#', '_' oder '$' bestehen.",
    'ERR_DB_PASSWORD' => 'Die Passwörter sind nicht gleich. Bitte geben Sie das selbe Passwort in beide Felder ein.',
    'ERR_DB_PRIV_USER' => 'Bitte geben Sie einen Benutzernamen für den Datenbankadministrator an. Dieser wird für das erstmalige Verbinden zur DB benötigt.',
    'ERR_DB_USER_EXISTS' => 'Der Benutzername für den SuiteCRM Datenbankbenutzer existiert bereits -- es kann kein zweiter mit dem gleichen Namen erstellt werden. Bitte geben Sie einen neuen Benutzernamen ein.',
    'ERR_DB_USER' => 'Einen Benutzernamen für den SuiteCRM Datenbank Administrator eingeben.',
    'ERR_DBCONF_VALIDATION' => 'Bitte beheben Sie die folgenden Fehler, bevor Sie fortfahren:',
    'ERR_DBCONF_PASSWORD_MISMATCH' => 'Die Passwörter sind nicht gleich. Bitte geben Sie das selbe Passwort in beide Felder ein.',
    'ERR_ERROR_GENERAL' => 'Die folgenden Fehler sind aufgetreten:',
    'ERR_LANG_CANNOT_DELETE_FILE' => 'Datei kann nicht gelöscht werden: ',
    'ERR_LANG_MISSING_FILE' => 'Datei kann nicht gefunden werden: ',
    'ERR_LANG_NO_LANG_FILE' => 'Keine Sprachpaket Datei in include/language gefunden:',
    'ERR_LANG_UPLOAD_1' => 'Beim Hochladen ist ein Problem aufgetreten. Bitte erneut versuchen.',
    'ERR_LANG_UPLOAD_2' => 'Sprachpakete müssen .zip Archive sein.',
    'ERR_LANG_UPLOAD_3' => 'PHP konnte die temp Datei nicht in das Upgrade Verzeichnis verschieben.',
    'ERR_LOG_DIRECTORY_NOT_EXISTS' => 'Das angegebene Log Verzeichnis ist kein gültiges Verzeichnis.',
    'ERR_LOG_DIRECTORY_NOT_WRITABLE' => 'Das angegebene Log Verzeichnis ist nicht beschreibbar.',
    'ERR_NO_DIRECT_SCRIPT' => 'Script konnte nicht direkt verarbeitet werden.',
    'ERR_NO_SINGLE_QUOTE' => 'Hochkomma kann nicht verwendet werden als',
    'ERR_PASSWORD_MISMATCH' => 'Die Passwörter für den SuiteCRM Admin stimmen nicht überein. Bitte geben Sie das selbe Passwort in beide Felder ein.',
    'ERR_PERFORM_CONFIG_PHP_1' => 'Die Datei <span class=stop>config.php </span> ist nicht beschreibbar.',
    'ERR_PERFORM_CONFIG_PHP_2' => 'Sie können mit der Installation fortfahren, indem Sie die config.php manuell erstellen und untenstehende Information einfügen. Allerdings MÜSSEN Sie die config.php erstellen, bevor Sie weitermachen können.',
    'ERR_PERFORM_CONFIG_PHP_3' => 'Haben Sie die config.php Datei erstellt?',
    'ERR_PERFORM_CONFIG_PHP_4' => 'Warnung: Es konnte nicht in die config.php Datei geschrieben werden. Stellen Sie sicher, dass sie existiert.',
    'ERR_PERFORM_HTACCESS_1' => 'ist nicht beschreibbar.',
    'ERR_PERFORM_HTACCESS_2' => ' Datei.',
    'ERR_PERFORM_HTACCESS_3' => 'Falls Sie die Log Datei vor dem Zugriff via Browser schützen wollen, erstellen Sie eine .htaccess Datei im Log Verzeichnis mit der Zeile:',
    'ERR_PERFORM_NO_TCPIP' => '<b>Wir konnten keine Internetverbindung erkennen.</b> Wenn Sie wieder eine Internetverbindung haben, besuchen Sie bitte <a href="https://www.suitecrm.com/">https://www.suitecrm.com/</a>, um sich bei SuiteCRM als Nutzer zu registrieren. Indem Sie uns ein Wenig darüber informieren, wie Sie planen SuiteCRM in Ihrem Unternehmen einzusetzen, können wir sicherstellen, dass wir Ihnen die richtige Anwendung für Ihre Unternehmensbedürfnisse liefern.',
    'ERR_SESSION_DIRECTORY_NOT_EXISTS' => 'Das angegebene Session Verzeichnis ist kein gültiges Verzeichnis.',
    'ERR_SESSION_DIRECTORY' => 'Das angegebene Session Verzeichnis ist nicht beschreibbar.',
    'ERR_SESSION_PATH' => 'Session Pfad wird benötigt, wenn Sie Ihren eigenen verwenden wollen.',
    'ERR_SI_NO_CONFIG' => 'Entweder ist die config_si.php nicht in der document root beinhaltet oder Sie haben $sugar_config_si nicht in der Datei config.php definiert.',
    'ERR_SITE_GUID' => 'Applikations ID wird benötigt, wenn Sie eine eigene verwenden wollen.',
    'ERROR_SPRITE_SUPPORT' => "Wir können die GD Bibliothek nicht finden, Sie werden daher die CSS Sprite Funktion nicht benutzen können.",
    'ERR_UPLOAD_MAX_FILESIZE' => 'Warnung: Ihre PHP Konfiguration muss geändert werden, so dass Dateien mit mindestens 6MB hochgeladen werden können.',
    'LBL_UPLOAD_MAX_FILESIZE_TITLE' => 'Upload Dateigröße',
    'ERR_URL_BLANK' => 'URL darf nicht leer sein.',
    'ERR_UW_NO_UPDATE_RECORD' => 'Installations-Datensatz nicht gefunden für',
    'ERROR_MANIFEST_TYPE' => 'Die Manifest-Datei muss den Typ der Anwendung spezifizieren.',
    'ERROR_PACKAGE_TYPE' => 'Manifest-Datei spezifiziert einen unbekannten Anwendungstyp.',
    'ERROR_VERSION_INCOMPATIBLE' => 'Die geladene Datei ist nicht mit dieser SuiteCRM Version kompatibel:',

    'LBL_BACK' => 'Zurück',
    'LBL_CANCEL' => 'Abbrechen',
    'LBL_ACCEPT' => 'Ich stimme zu',
    'LBL_CHECKSYS_LEGACY_CACHE' => 'Writable Legacy Cache Sub-Directories',
    'LBL_CHECKSYS_CACHE' => 'Beschreibbare Cache Unterverzeichnisse',
    'LBL_CHECKSYS_EXTENSIONS' => 'Writable Extensions Directory',
    'LBL_CHECKSYS_SECRETS' => 'Writable Config/Secrets Directory',
    'LBL_CHECKSYS_LOGS' => 'Writable Log Directory',
    'LBL_DROP_DB_CONFIRM' => 'Der Datenbankname existiert bereits. Sie können<br>1.  zurückgehen und einen anderen Namen wählen <br>2.  auf weiter drücken und fortfahren, allerdings werden dann alle existierenden Tabellen gelöscht. <strong>Dies bedeutet, dass Ihre Tabellen für immer verloren gehen.</strong>',
    'LBL_CHECKSYS_COMPONENT' => 'Komponente',
    'LBL_CHECKSYS_CONFIG' => 'Beschreibbare SuiteCRM Konfigurationsdatei (config.php)',
    'LBL_CHECKSYS_CURL' => 'cURL Modul',
    'LBL_CHECKSYS_CUSTOM' => 'Beschreibbares Custom Verzeichnis',
    'LBL_CHECKSYS_DATA' => 'Beschreibbare Daten Unterverzeichnisse',
    'LBL_CHECKSYS_IMAP' => 'IMAP Modul',
    'LBL_CHECKSYS_FASTCGI' => 'FastCGI',
    'LBL_CHECKSYS_MBSTRING' => 'MB Zeichenketten-Modul',
    'LBL_CHECKSYS_MEM_OK' => 'OK (Kein Limit)',
    'LBL_CHECKSYS_MEM_UNLIMITED' => 'OK (Unlimitiert)',
    'LBL_CHECKSYS_MEM' => 'PHP Speicher Limit',
    'LBL_CHECKSYS_MODULE' => 'Beschreibbare Modul Unterverzeichnisse und Dateien',
    'LBL_CHECKSYS_NOT_AVAILABLE' => 'Nicht verfügbar',
    'LBL_CHECKSYS_OK' => 'OK',
    'LBL_CHECKSYS_PHP_INI' => 'Speicherort Ihrer PHP-Konfigurationsdatei (php.ini):',
    'LBL_CHECKSYS_PHP_OK' => 'OK (Ver.',
    'LBL_CHECKSYS_PHPVER' => 'PHP Version',
    'LBL_CHECKSYS_IISVER' => 'IIS Version',
    'LBL_CHECKSYS_JSON' => 'JSON Parsing',
    'LBL_CHECKSYS_RECHECK' => 'Überprüfung wiederholen',
    'LBL_CHECKSYS_STATUS' => 'Status',
    'LBL_CHECKSYS_TITLE' => 'Systemüberprüfung Akzeptanz',
    'LBL_CHECKSYS_XML' => 'XML Parsen',
    'LBL_CHECKSYS_ZLIB' => 'ZLIB Kompression Modul',
    'LBL_CHECKSYS_ZIP' => 'ZIP Handling Modul',
    'LBL_CHECKSYS_PCRE' => 'PCRE Bibliothek',
    'LBL_CHECKSYS_ENV' => 'Writable .env',
    'LBL_CHECKSYS_FIX_FILES' => 'Bitte korrigieren Sie die folgenden Dateien oder Verzeichnisse, bevor Sie fortfahren:',
    'LBL_CHECKSYS_FIX_MODULE_FILES' => 'Bitte korrigieren Sie die folgenden Modulverzeichnisse und die Dateien darunter bevor Sie fortfahren:',
    'LBL_CHECKSYS_UPLOAD' => 'Beschreibbares Upload Verzeichnis',
    'LBL_CHECKSYS_INTL_EXTENSIONS' => 'Intl Exists in Extensions',
    'LBL_CHECKSYS_JSON_EXTENSIONS' => 'Json Exists in Extensions',
    'LBL_CHECKSYS_GD_EXTENSIONS' => 'GD Exists in Extensions',
    'LBL_CHECKSYS_OPENSSL_EXTENSIONS' => 'OpenSSL Exists in Extensions',
    'LBL_CHECKSYS_ZIP_EXTENSIONS' => 'Zip Exists in Extensions',
    'LBL_CHECKSYS_PDO_MYSQL_EXTENSIONS' => 'PDO MySQL Exists in Extensions',
    'LBL_CHECKSYS_CURL_EXTENSIONS' => 'cURL Exists in Extensions',
    'LBL_CHECKSYS_MBSTRING_EXTENSIONS' => 'MB Strings Exists in Extensions',
    'LBL_CHECKSYS_MYSQLI_EXTENSIONS' => 'MySQLi Exists in Extensions',
    'LBL_CHECKSYS_SOAP_EXTENSIONS' => 'Soap Exists in Extensions',
    'LBL_CHECKSYS_XML_EXTENSIONS' => 'XML Exists in Extensions',
    'LBL_CHECKSYS_IMAP_EXTENSIONS' => 'IMAP Exists in Extensions (Optional)',
    'LBL_CHECKSYS_LDAP_EXTENSIONS' => 'LDAP Exists in Extensions (Optional)',
    'LBL_PHP_CHECKS' => 'PHP CHECKS',
    'LBL_SERVER_CHECKS' => 'SERVER CHECKS',
    'LBL_PERMISSION_CHECKS' => 'PERMISSION CHECKS',
    'LBL_CHECK_FAILED' => 'Check Failed: ',
    'ERR_CHECKSYS_INTL' => 'The extension Intl is not installed, please contact your system administrator',
    'ERR_CHECKSYS_JSON' => 'The extension JSON is not enabled, please contact your system administrator.',
    'ERR_CHECKSYS_GD' => 'The extension GD is not enabled, please contact your system administrator.',
    'ERR_CHECKSYS_OPENSSL' => 'The extension OpenSSL is not enabled, please contact your system administrator.',
    'ERR_CHECKSYS_PDO_MYSQL' => 'The extension PDO MySQL is not enabled, please contact your system administrator.',
    'ERR_CHECKSYS_MYSQLI' => 'The extension MySQLi is not enabled, please contact your system administrator.',
    'ERR_CHECKSYS_SOAP' => 'The extension Soap is not enabled, please contact your system administrator.',
    'ERR_SUHOSIN' => 'Upload stream is blocked by Suhosin, please add &quot;upload&quot; to suhosin.executor.include.whitelist (See suitecrm.log for more information)',
    'LBL_UNWRITABLE_SUB_DIR' => 'There are some sub directories that are unwritable. Please take the necessary steps to make the directories writeable ',
    'LBL_REFER_TO_LOGS' => 'There has been an issue in one of your pre-installation checks, please refer to the install.log',
    'LBL_NOT_A_VALID_SUITECRM_PAGE' => 'The SuiteCRM Title cannot be found. This is not a valid SuiteCRM Page.',
    'LBL_NOT_COOKIE_OR_TOKEN' => 'Cannot find cookies, no valid token found. Please refer to the install.log for more information.',
    'LBL_CURL_JSON_ERROR' => 'The result of the curl call to the graphql page was empty.',
    'LBL_UNABLE_TO_FIND_SYSTEM_CONFIGS' => 'Unable to retrieve System Configs on Graphql Page. Please refer to the install.log for more information.',
    'LBL_CURL_REQUEST_MAIN_PAGE' => 'Curl Request on Main Page',
    'LBL_CURL_REQUEST_API_PAGE' => 'Curl-Anfrage für Api',
    'LBL_ERROR_DETAILS' => 'Error Details',
    'LBL_ERROR' => 'Fehler',
    'LBL_WARNING_DETAILS' => 'Warning Details',
    'LBL_WARNING' => 'Warnung',
    'LBL_SYSTEM_CHECKS' => 'SYSTEM CHECKS',
    'LBL_CRON_INSTRUCTIONS_1' => 'In order to run SuiteCRM Schedulers, edit your web server users crontab file with this command:',
    'LBL_CRON_INSTRUCTIONS_2' => 'and add the following line to the crontab file:',
    'LBL_CRON_INSTRUCTIONS_3' => 'Sie sollten dies erst nach Abschluss der Installation machen.',
    'LBL_CRON_CONFIGURATION' => 'CRON CONFIGURATION',
    'LBL_SETUP_CRONTAB' => 'To Setup Crontab',
    'LBL_ROUTE_ACCESS_CHECK' => 'ROUTE ACCESS CHECK',
    'LBL_PHP_MEM_1' => 'Your PHP Memory Limit is ',
    'LBL_PHP_MEM_2' => '. This has to be a minimum of ',
    'LBL_PHP_MEM_3' => 'M to continue.',
    'LBL_CLOSE' => 'Schließen',
    'LBL_THREE' => '3',
    'LBL_CONFIRM_BE_CREATED' => 'erstellt',
    'LBL_CONFIRM_DB_TYPE' => 'Datenbanktyp',
    'LBL_CONFIRM_NOT' => 'nicht',
    'LBL_CONFIRM_TITLE' => 'Einstellungen bestätigen',
    'LBL_CONFIRM_WILL' => 'wird',
    'LBL_DBCONF_DB_DROP' => 'Tabellen löschen',
    'LBL_DBCONF_DB_NAME' => 'Datenbank Name',
    'LBL_DBCONF_DB_PORT' => 'Datenbank-Port',
    'LBL_DBCONF_DB_PASSWORD' => 'SuiteCRM Datenbank Benutzer Password',
    'LBL_DBCONF_DB_PASSWORD2' => 'SuiteCRM Datenbank Benutzer Password bestätigen',
    'LBL_DBCONF_DB_USER' => 'SuiteCRM Datenbankbenutzer',
    'LBL_DBCONF_SUITE_DB_USER' => 'SuiteCRM Datenbankbenutzer',
    'LBL_DBCONF_DB_ADMIN_USER' => 'Datenbankadministrator Benutzername',
    'LBL_DBCONF_DB_ADMIN_PASSWORD' => 'Datenbankadministrator Passwort',
    'LBL_DBCONF_COLLATION' => 'Kollation',
    'LBL_DBCONF_CHARSET' => 'Zeichensatz',
    'LBL_DBCONF_ADV_DB_CFG_TITLE' => 'Erweiterte Datenbankkonfiguration',
    'LBL_DBCONF_DEMO_DATA' => 'Datenbank mit Demodaten füllen?',
    'LBL_DBCONF_DEMO_DATA_TITLE' => 'Demodaten auswählen',
    'LBL_DBCONF_HOST_NAME' => 'Host Name',
    'LBL_DBCONF_HOST_INSTANCE' => 'Host Instanz',
    'LBL_DBCONFIG_SECURITY' => 'Aus Sicherheitsgründen können Sie einen exklusiven Datenbank Benutzer festlegen um mit der SuiteCRM Datenbank zu kommunizieren. Dieser Benutzer muss in der Datenbank dieser Instanz lesen, schreiben und aktualisieren können. Es kann entweder der Datenbank Administrator wie oben angegeben sein, oder Sie geben Informationen zu einem neuen oder existierenden anderen Benutzer an.',
    'LBL_DBCONFIG_PROVIDE_DD' => 'Existierenden Benutzer angeben',
    'LBL_DBCONFIG_CREATE_DD' => 'Benutzer eingeben, der erstellt werden soll',
    'LBL_DBCONFIG_SAME_DD' => 'Wie Admin Benutzer',
    'LBL_DBCONF_TITLE' => 'Datenbankkonfiguration',
    'LBL_DBCONF_TITLE_NAME' => 'Datenbankname angeben',
    'LBL_DBCONF_TITLE_USER_INFO' => 'Datenbank Benutzerinformationen angeben',
    'LBL_DBCONF_TITLE_PSWD_INFO_LABEL' => 'Kennwort',
    'LBL_DISABLED_DESCRIPTION_2' => 'Nachdem diese Änderung durchgeführt wurde, können Sie auf \'Start\' klicken um mit der Installation zu beginnen. <i>Wenn die Installation beendet ist, sollten Sie den Wert von \'installer_locked\' auf \'true\' setzen.</i>',
    'LBL_DISABLED_DESCRIPTION_3' => 'After this change has been made, please revisit / reload this page to continue.',
    'LBL_DISABLED_DESCRIPTION' => 'Die Installationsroutine ist bereits einmal gelaufen. Aus Sicherheitsgründen kann sie kein zweites Mal aufgerufen werden. Falls Sie sicher sind, dass Sie den Installer ein zweites Mal ausführen möchten, müssen Sie die Variable \'installer_locked\' in der Datei config.php auf \'false\' setzen (oder hinzufügen). Die Zeile sollte so aussehen:',
    'LBL_DISABLED_HELP_1' => 'Für Hilfe zur Installation besuchen Sie die SuiteCRM',
    'LBL_DISABLED_HELP_LNK' => 'https://community.suitecrm.com',
    'LBL_DISABLED_HELP_2' => 'Support Foren',
    'LBL_APP_NOT_INSTALLED' => 'SuiteCRM ist nicht installiert. Der Einsprungpunkt benötigt ein installiertes SuiteCRM, bitte installieren Sie es zuerst.',
    'LBL_DISABLED_TITLE_2' => 'SuiteCRM Installation ist deaktiviert',
    'LBL_HELP' => 'Hilfe',
    'LBL_INSTALL' => 'Installieren',
    'LBL_INSTALL_TYPE_TITLE' => 'Installationsoptionen',
    'LBL_INSTALL_TYPE_SUBTITLE' => 'Installationstyp wählen',
    'LBL_INSTALL_TYPE_TYPICAL' => ' <b>Typische Installation</b>',
    'LBL_INSTALL_TYPE_CUSTOM' => ' <b>Benutzerdefinierte Installation</b>',
    'LBL_INSTALL_TYPE_MSG2' => 'Benötigt nur wenige Angaben für die Installation. Wird für neue Benutzer empfohlen.',
    'LBL_INSTALL_TYPE_MSG3' => 'Ermöglicht die Eingabe von erweiterten Optionen während der Installation. Die meisten dieser Einstellungen sind allerdings auch von innerhalb des Programms im Admin Bereich erreichbar. Empfohlen für fortgeschrittene Benutzer.',
    'LBL_LANG_1' => 'Um in SuiteCRM eine andere Sprache als Englisch (US-Englisch) zu verwenden, können Sie ein Sprachpaket hochladen und installieren. Sie können dies aber auch von innerhalb der Applikation durchführen (empfohlen). Wenn Sie diesen Schritt überspringen möchten, klicken Sie bitte auf Weiter.',
    'LBL_LANG_BUTTON_COMMIT' => 'Installieren',
    'LBL_LANG_BUTTON_REMOVE' => 'Entfernen',
    'LBL_LANG_BUTTON_UNINSTALL' => 'Deinstallieren',
    'LBL_LANG_BUTTON_UPLOAD' => 'Hochladen',
    'LBL_LANG_NO_PACKS' => 'Keine Einträge vorhanden',
    'LBL_LANG_PACK_INSTALLED' => 'Die folgenden Sprachpakete wurden installiert:',
    'LBL_LANG_PACK_READY' => 'Die folgenden Sprachpakete sind bereit für die Installation:',
    'LBL_LANG_SUCCESS' => 'Das Sprachpaket wurde erfolgreich hochgeladen.',
    'LBL_LANG_TITLE' => 'Sprachpaket',
    'LBL_LAUNCHING_SILENT_INSTALL' => 'SuiteCRM wird jetzt installiert. Der Vorgang kann einige Minuten dauern.',
    'LBL_SILENT_INSTALL_SUCCESS' => 'SuiteCRM wurde erfolgreich installiert.',
    'LBL_SILENT_INSTALL_FAILED' => 'SuiteCRM Installation fehlgeschlagen.',
    'LBL_LANG_UPLOAD' => 'Sprachpaket hochladen',
    'LBL_LICENSE_ACCEPTANCE' => 'Akzeptieren Sie die Lizenzbestimmungen',
    'LBL_LICENSE_CHECKING' => 'Überprüfe Systemkompatibilität.',
    'LBL_LICENSE_CHKENV_HEADER' => 'Überprüfe Systemumgebung',
    'LBL_LICENSE_CHKDB_HEADER' => 'Überprüfe DB Anmeldedaten.',
    'LBL_LICENSE_CHECK_PASSED' => 'System hat den Kompatibilitätstest bestanden.',
    'LBL_CREATE_CACHE' => 'Vorbereitung der Installation...',
    'LBL_LICENSE_REDIRECT' => 'Weiterleiten in',
    'LBL_LICENSE_I_ACCEPT' => 'Ich stimme zu',
    'LBL_LICENSE_PRINTABLE' => ' Druckbare Ansicht ',
    'LBL_PRINT_SUMM' => 'Zusammenfassung drucken',
    'LBL_LICENSE_TITLE_2' => 'SuiteCRM-Lizenz',
    'LBL_LICENSE' => 'LIZENZ',

    'LBL_LOCALE_NAME_FIRST' => 'Hans',
    'LBL_LOCALE_NAME_LAST' => 'Muster',
    'LBL_LOCALE_NAME_SALUTATION' => 'Dr.',

    'LBL_ML_ACTION' => 'Aktion',
    'LBL_ML_DESCRIPTION' => 'Beschreibung',
    'LBL_ML_INSTALLED' => 'Installationsdatum',
    'LBL_ML_NAME' => 'Name',
    'LBL_ML_PUBLISHED' => 'Veröffentlichungsdatum',
    'LBL_ML_TYPE' => 'Typ',
    'LBL_ML_UNINSTALLABLE' => 'Deinstallierbar',
    'LBL_ML_VERSION' => 'Version',
    'LBL_MSSQL' => 'SQL Server',
    'LBL_MSSQL2' => 'SQL Server (FreeTDS)',
    'LBL_MSSQL_SQLSRV' => 'SQL Server (Microsoft SQL Server Treiber für PHP)',
    'LBL_MYSQL' => 'MySQL',
    'LBL_MYSQLI' => 'MySQL (mysqli Erweiterung)',
    'LBL_NEXT' => 'Weiter',
    'LBL_NO' => 'Nein',
    'LBL_PERFORM_ADMIN_PASSWORD' => 'Site admin Passwort setzen',
    'LBL_PERFORM_CONFIG_PHP' => 'SuiteCRM Konfigurationsdatei wird erstellt',
    'LBL_PERFORM_CREATE_DB_1' => '<b>Datenbank wird erstellt</b>',
    'LBL_PERFORM_CREATE_DB_2' => ' <b>auf</b> ',
    'LBL_PERFORM_CREATE_DB_USER' => 'Datenbank Benutzername und Passwort wird erstellt...',
    'LBL_PERFORM_CREATE_DEFAULT' => 'Standard SuiteCRM Daten werden erstellt',
    'LBL_PERFORM_DEFAULT_SCHEDULER' => 'Standard Zeitplaner Aufgaben werden erstellt',
    'LBL_PERFORM_DEFAULT_USERS' => 'Standard Benutzer werden erstellt',
    'LBL_PERFORM_DEMO_DATA' => 'Datenbank wird mit Demo Daten gefüllt (dies kann einige Zeit dauern)',
    'LBL_PERFORM_DONE' => 'fertig<br>',
    'LBL_PERFORM_FINISH' => 'Ende',
    'LBL_PERFORM_OUTRO_1' => 'Die Installation von SuiteCRM ',
    'LBL_PERFORM_OUTRO_2' => ' ist nun vervollständigt!',
    'LBL_PERFORM_OUTRO_3' => 'Gesamtzeit: ',
    'LBL_PERFORM_OUTRO_4' => ' Sekunden.',
    'LBL_PERFORM_OUTRO_5' => 'Ungefährer Speicherverbrauch:',
    'LBL_PERFORM_OUTRO_6' => 'Bytes.',
    'LBL_PERFORM_SUCCESS' => 'Erfolgreich!',
    'LBL_PERFORM_TABLES' => 'SuiteCRM Applikationstabellen, Audit Tabellen und Beziehungs Metadaten werden erstellt...',
    'LBL_PERFORM_TITLE' => 'Setup durchführen',
    'LBL_PRINT' => 'Drucken',
    'LBL_REG_CONF_1' => 'Bitte füllen Sie das kurze Formular unten aus, um Produktankündigungen, Schulungsneuigkeiten, spezielle Angebote und Einladungen von SuiteCRM zu erhalten. Ihre Daten werden von uns nur zu eigenen Zwecken verwendet und niemals an Dritte verkauft, vermietet oder anderweitig weitergegeben.',
    'LBL_REG_CONF_3' => 'Vielen Dank für die Registrierung. Klicken Sie auf die Beenden Schaltfläche um sich bei SuiteCRM anzumelden. Das erste Mal müssen Sie sich mit dem Benutzernamen \'admin\' anmelden und das Passwort von Schritt 2 eingeben.',
    'LBL_REG_TITLE' => 'Registrierung',

    'LBL_REQUIRED' => '* Pflichtfeld',

    'LBL_SITECFG_ADMIN_Name' => 'SuiteCRM Anwendung Admin Name',
    'LBL_SITECFG_ADMIN_PASS_2' => 'Suite CRM Admin Benutzerpasswort erneut eingeben',
    'LBL_SITECFG_ADMIN_PASS' => 'SuiteCRM Admin Benutzerpasswort',
    'LBL_SITECFG_APP_ID' => 'Anwendungs ID',
    'LBL_SITECFG_CUSTOM_ID_DIRECTIONS' => 'Falls ausgewählt, müssen Sie die automatisch generierte Applikations ID  mit einer neu angegebenen überschreiben. Dies verhindert, dass Sessions einer SuiteCRM Instanz von einer anderen Instanz verwendet werden. Im Falle eines Clusters von SuiteCRM Installationen, müssen alle die gleiche Applikations-ID verwenden.',
    'LBL_SITECFG_CUSTOM_ID' => 'Geben Sie Ihre eigene Anwendungs ID ein',
    'LBL_SITECFG_CUSTOM_LOG_DIRECTIONS' => 'Falls ausgewählt, müssen Sie ein Log Verzeichnis zum Überschreiben des Standardverzeichnis der SuiteCRM Logs angeben. Egal wo sich die Logdatei befindet, der Zugriff zum Verzeichnis via Browser wird mit Hilfe eines .htaccess Redirect verhindert.',
    'LBL_SITECFG_CUSTOM_LOG' => 'Benutzerdefiniertes Log Verzeichnis verwenden',
    'LBL_SITECFG_CUSTOM_SESSION_DIRECTIONS' => 'Falls ausgewählt, müssen Sie ein sicheres Verzeichnis für die Speicherung der Session Informationen angeben, um zu verhindern, dass Session Daten auf einem geteiltem Server gefährdet sind.',
    'LBL_SITECFG_CUSTOM_SESSION' => 'Benutzerdefiniertes Session Verzeichnis für SuiteCRM verwenden',
    'LBL_SITECFG_FIX_ERRORS' => '<b>Bitte beheben Sie die folgenden Fehler bevor Sie fortfahren.:</b>',
    'LBL_SITECFG_LOG_DIR' => 'Log Verzeichnis',
    'LBL_SITECFG_SESSION_PATH' => 'Pfad zum Session Verzeichnis<br />(muss beschreibbar sein)',
    'LBL_SITECFG_SITE_SECURITY' => 'Wählen Sie die Sicherheitsoptionen',
    'LBL_SITECFG_SUITE_UP_DIRECTIONS' => 'Falls aktiviert, wird das System regelmäßig nach aktuellen Updates suchen.',
    'LBL_SITECFG_SUITE_UP' => 'Automatisch nach Updates suchen?',
    'LBL_SITECFG_TITLE' => 'Site Konfiguration',
    'LBL_SITECFG_TITLE2' => 'Admin Benutzer identifizieren',
    'LBL_SITECFG_SECURITY_TITLE' => 'Seiten Sicherheit',
    'LBL_SITECFG_URL' => 'URL der SuiteCRM-Instanz',
    'LBL_SITECFG_ANONSTATS' => 'Anonyme Benutzerstatistiken senden?',
    'LBL_SITECFG_ANONSTATS_DIRECTIONS' => 'Falls aktiviert, wird das System bei jeder Suche nach Updates <b>anonyme</b> Statistiken über Ihr System an SuiteCRM Inc. senden. Diese Information hilft uns besser zu verstehen, wie die Applikation verwendet wird und führt zu Produktverbesserungen',
    'LBL_SITECFG_URL_MSG' => 'Geben Sie die URL ein, die nach der Installation verwendet wird, um Ihre SuiteCRM Instanz aufzurufen. Diese URL wird auch als Basis für die URLs in den SuiteCRM Seiten verwendet. Die URL muss den Webserver oder den Maschinenname oder die IP Adresse enthalten.',
    'LBL_SITECFG_SYS_NAME_MSG' => 'Geben Sie einen Namen für Ihr System ein. Dieser Name wird in der Titelleiste des Browsers angezeigt wenn jemand SuiteCRM aufruft.',
    'LBL_SITECFG_PASSWORD_MSG' => 'Nach der Installation benötigen Sie den SuiteCRM Admin Benutzer (Benutzername = admin) um einzuloggen. Geben Sie ein Passwort für diesen Administrator Benutzer ein, Sie können dieses nach dem ersten Login wieder ändern. Sie können außerdem noch einen anderen Administrator Benutzernamen eingeben und diesen neben dem Standardwert benutzen.',
    'LBL_SITECFG_COLLATION_MSG' => 'Wählen Sie die Sortierregeln (collation) für Ihr System. Diese Einstellungen erstellen Tabellen in Ihrer spezifischen Sprache. Wenn Sie keine speziellen Einstellungen benötigen dann wählen Sie den Standardwert.',
    'LBL_SPRITE_SUPPORT' => 'Sprite Unterstützung',
    'LBL_SYSTEM_CREDS' => 'System Zugangsdaten',
    'LBL_SYSTEM_ENV' => 'Systemumgebung',
    'LBL_SHOW_PASS' => 'Zeige Passwörter',
    'LBL_HIDE_PASS' => 'Passwörter verbergen',
    'LBL_PRE_INSTALL_REQ' => 'Pre-Installation requirements',
    'LBL_HIDDEN' => '<i>(verborgen)</i>',
    'LBL_STEP1' => 'Schritt 1 von 2 - Bedingungen vor der Installation',
    'LBL_STEP2' => 'Schritt 2 von 2 - Konfiguration',
    'LBL_STEP' => 'Schritt',
    'LBL_TITLE_WELCOME' => 'Willkommen beim SuiteCRM',
    'LBL_WELCOME' => 'Willkommen bei SuiteCRM',
    //welcome page variables
    'LBL_TITLE_ARE_YOU_READY' => 'Sind Sie bereit für die Installation?',
    'REQUIRED_SYS_COMP' => 'Benötigte Systemkomponenten',
    'REQUIRED_SYS_COMP_MSG' =>
        'Bevor Sie beginnen, achten Sie darauf, dass Sie die unterstützten Versionen der folgenden Systemkomponenten haben: <br><ul><li>/Datenbank-Management-System (Beispiele: MariaDB, MySQL oder SQL Server)</li> <li>Web-Server (Apache, IIS)</li></ul> Kompatible Systemkomponenten, für die SuiteCRM Version, die Sie installieren möchten, finden Sie in der Kompatibilitätsmatrix. Diese finden Sie in den Release Notes. <br>',
    'REQUIRED_SYS_CHK' => 'Initiale System Überprüfung',
    'REQUIRED_SYS_CHK_MSG' =>
        'Wen Sie mit dem Installationsprozess starten, wird ein System-Test auf Ihrem Webserver ausgeführt. Dadurch wird sichergestellt, dass dieser korrekt Konfiguriert wird um einen reibungslosen Betrieb von Suite CRM zu gewähren. <br><br>
                      Der System-Test umfasst folgendes:<br>
                      <ul>
                      <li><b>PHP Version</b> &#8211; muss mit dieser Anwendung kompatibel sein</li>
                      <li><b>Session Variablen</b> &#8211; müssen ordnungsgemäß funktionieren</li>
                      <li><b>MB Strings</b> &#8211; müssen installiert und in der php.ini aktiviert sein</li>
                      <li><b>Datenbank-Unterstützung</b> &#8211; für MariaDB, MySQL oder andere SQL-Server muss verfügbar sein</li>
                      <li><b>Config.php</b> &#8211; muss vorhanden und beschreibbar sein</li>
                      <li>Die folgenden SuiteCRM-Dateien müssen beschreibbar sein:<ul><li><b>/custom</li>
                      <li>/cache</li>
                      <li>/modules</li>
                      <li>/upload</b></li></ul></li></ul>
                                  Sollte der Test nicht bestanden werden, kann die Installation nicht fortgeführt werden.
                                  In der Fehlermeldung wird beschrieben, weshalb der Test nicht bestanden wurde.
                                  Sobald diese Mängel behoben wurden, können Sie die Installation fortfahren.<br>',


    'REQUIRED_INSTALLTYPE' => 'Typische oder benutzerdefinierte Installation',
    'REQUIRED_INSTALLTYPE_MSG' =>
        'Nachdem die Systemüberprüfung durchgeführt wurde, können Sie beide auswählen"',
    'LBL_WELCOME_PLEASE_READ_BELOW' => 'Bitte lesen Sie die folgenden wichtigen Informationen bevor Sie mit der Installation fortfahren. Diese werden Ihnen helfen zu bestimmen, ob Sie die notwendigen Voraussetzungen haben um SuiteCRM jetzt zu installieren.',

    'LBL_WELCOME_CHOOSE_LANGUAGE' => '<b>Wählen Sie Ihre Sprache</b>',
    'LBL_WELCOME_SETUP_WIZARD' => 'Setup Assistenten',
    'LBL_WIZARD_TITLE' => 'SuiteCRM Setup Assistent:',
    'LBL_YES' => 'Ja',

    'LBL_PATCHES_TITLE' => 'Installation der neuesten Patches',
    'LBL_MODULE_TITLE' => 'Installieren von Language Packs',
    'LBL_PATCH_1' => 'Sollten Sie diesen Schritt überspringen wollen, klicken Sie bitte auf Weiter.',
    'LBL_PATCH_TITLE' => 'System-Patches',
    'LBL_PATCH_READY' => 'Die folgenden Patches können jetzt installiert werden:',
    'LBL_SESSION_ERR_DESCRIPTION' => "SuiteCRM vertraut auf PHP Sessions, um wichtige Informationen zu speichern, während es zu diesem Webserver verbunden ist. Ihre PHP Installation weist keine korrekten Einstellungen der Sessioninformationen auf.\"",
    'LBL_SESSION_ERR_TITLE' => 'PHP Session Konfigurationsfehler',
    'LBL_SYSTEM_NAME' => 'Systemname',
    'LBL_COLLATION' => 'Sortiereinstellungen (Collation)',
    'LBL_REQUIRED_SYSTEM_NAME' => 'Geben Sie einen Systemnamen für die SuiteCRM Instanz an.',
    'LBL_PATCH_UPLOAD' => 'Wählen Sie eine Patch Datei von Ihrem lokalen Computer',
    'LBL_INCOMPATIBLE_PHP_VERSION' => 'PHP Version 5 oder höher wird benötigt.',
    'LBL_MINIMUM_PHP_VERSION' => 'Php Version 5.1.0 oder höher wird benötigt. Empfohlen: 5.2.x',
    'LBL_YOUR_PHP_VERSION' => '(Ihre aktuelle PHP Version ist',
    'LBL_RECOMMENDED_PHP_VERSION' => 'Empfohlene php Version ist 5.2.x)',
    'LBL_BACKWARD_COMPATIBILITY_ON' => 'PHP Abwärts Kompatibilitätsmodus ist eingeschaltet. Setzen Sie den zend.ze1_compatibility_mode auf Off um fortzufahren.',
    'LBL_STREAM' => 'PHP die Benutzung von stream',

    'advanced_password_new_account_email' => array(
        'subject' => 'New account information',
        'type' => 'System',
        'description' => 'Diese Vorlage wird verwendet, wenn der Administrator ein neues Kennwort an einen Benutzer sendet.',
        'body' => '<div><table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width="550" align=\\"\\&quot;\\&quot;center\\&quot;\\&quot;\\"><tbody><tr><td colspan=\\"2\\"><p>Hier ist Ihr Benutzername und das temporäre Kennwort:</p> <p>Benutzername: $contact_user_user_name</p> <p>Passwort: $contact_user_user_hash</p> <br><p>$config_site_url</p> <br><p>nachdem Sie sich mit den oben genannten Kennwort anmelden, werden Sie aufgefordert es mit einem neuen Kennwort Ihrer Wahl zu ändern.</p> </td> </tr><tr><td colspan=\\"2\\"></td> </tr> </tbody></table> </div>',
        'txt_body' =>
            '
Folgend Ihr Benutzername und Ihr temporäres Passwort:
Benutzername : $contact_user_user_name
Passwort : $contact_user_user_hash

$config_site_url

Nach dem Login mit obigen temporär Password müssen Sie möglicherweise ein neues Passwort Ihrer Wahl eingeben.',
        'name' => 'System generiertes Passwort email',
    ),
    'advanced_password_forgot_password_email' => array(
        'subject' => 'Ihr Kennwort zurücksetzen',
        'type' => 'System',
        'description' => "Diese Vorlage wird verwendet, wenn einem Benutzer der Link zum Zurücksetzen des Passwortes geschickt wird.",
        'body' => '<div><table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width="550" align=\\"\\&quot;\\&quot;center\\&quot;\\&quot;\\"><tbody><tr><td colspan=\\"2\\"><p>Sie haben kürzlich hier $contact_user_pwd_last_changed die Zurücksetzung Ihres Passwortes angefordert. </p><p>Klicken Sie den unten stehenden Link, um das Passwort zurück zu setzen:</p><p> $contact_user_link_guid </p> </td> </tr><tr><td colspan=\\"2\\"></td> </tr> </tbody></table> </div>',
        'txt_body' =>
            '
Sie haben kürzlich die Rücksetzung Ihres Passwortes beantragt $contact_user_pwd_last_changed 

Benutzen Sie folgenden Link um Ihr Passwort zurückzusetzen:

$contact_user_link_guid',
        'name' => 'Passwort-Vergessen e-Mail',
    ),


    'two_factor_auth_email' => array(
        'subject' => 'Zwei-Faktor-Authentifizierung',
        'type' => 'System',
        'description' => "Dieses Template wird benützt, um den Benutzercode für die zwei-Faktor-Authentifizierung zu versenden.",
        'body' => '<div><table border=\\"0\\" cellspacing=\\"0\\" cellpadding=\\"0\\" width="550" align=\\"\\&quot;\\&quot;center\\&quot;\\&quot;\\"><tbody><tr><td colspan=\\"2\\"><p>Der Zwei-Faktor-Authentifizierungs-Code ist <b>$code</b>.</p>  </td>         </tr><tr><td colspan=\\"2\\"></td>         </tr> </tbody></table> </div>',
        'txt_body' =>
            'Der Code für die Zwei-Faktor-Authentifizierung lautet $code.',
        'name' => 'Email für die Zwei-Faktor-Authentifizierung',
    ),

    // SMTP settings

    'LBL_FROM_NAME' => '"Von" Name:',
    'LBL_FROM_ADDR' => '"Von" Adresse:',

    'LBL_WIZARD_SMTP_DESC' => 'Geben Sie das E-Mail Konto an, das verwendet wird, um Zuweisungen und neue Passwörter zu versenden. Benutzer erhalten dann die betreffenden E-Mails von diesem Konto.',
    'LBL_CHOOSE_EMAIL_PROVIDER' => 'Wählen Sie Ihren E-Mail Anbieter:',

    'LBL_SMTPTYPE_GMAIL' => 'Gmail',
    'LBL_SMTPTYPE_YAHOO' => 'Yahoo! Mail',
    'LBL_SMTPTYPE_EXCHANGE' => 'Microsoft Exchange',
    'LBL_SMTPTYPE_OTHER' => 'Andere',
    'LBL_MAIL_SMTP_SETTINGS' => 'SMTP Server Specifikation',
    'LBL_MAIL_SMTPSERVER' => 'SMTP Server:',
    'LBL_MAIL_SMTPPORT' => 'SMTP Port:',
    'LBL_MAIL_SMTPAUTH_REQ' => 'SMTP Authentifizierung verwenden?',
    'LBL_EMAIL_SMTP_SSL_OR_TLS' => 'SMTP über SSL oder TLS aktivieren',
    'LBL_GMAIL_SMTPUSER' => 'Gmail E-Mail Adresse:',
    'LBL_GMAIL_SMTPPASS' => 'Gmail Passwort:',
    'LBL_ALLOW_DEFAULT_SELECTION' => 'Benutzern erlauben, dieses Konto für ausgehende E-Mails zu verwenden:',
    'LBL_ALLOW_DEFAULT_SELECTION_HELP' => 'Wenn diese Option gewählt wurde, können alle Benutzer E-Mails über dieses für Systembenachrichtigungen eingerichtete Konto senden. Wenn nicht ausgewählt, können Benutzer trotzdem E-Mails über ihre selbst konfigurierten Mail Server versenden.',

    'LBL_YAHOOMAIL_SMTPPASS' => 'Yahoo! Mail Passwort:',
    'LBL_YAHOOMAIL_SMTPUSER' => 'Yahoo! Mail ID:',

    'LBL_EXCHANGE_SMTPPASS' => 'Exchange Passwort:',
    'LBL_EXCHANGE_SMTPUSER' => 'Exchange Benutzername:',
    'LBL_EXCHANGE_SMTPPORT' => 'Exchange Server Port:',
    'LBL_EXCHANGE_SMTPSERVER' => 'Exchange Server:',


    'LBL_MAIL_SMTPUSER' => 'SMTP Benutzername:',
    'LBL_MAIL_SMTPPASS' => 'SMTP Passwort:',

    // Branding

    'LBL_WIZARD_SYSTEM_TITLE' => 'Branding',
    'LBL_WIZARD_SYSTEM_DESC' => 'Geben Sie den Namen und das Logo Ihrer Organisation ein, um SuiteCRM zu individualisieren',
    'SYSTEM_NAME_WIZARD' => 'Name:',
    'SYSTEM_NAME_HELP' => 'Das ist der Name, der in der Titelzeile (im Reiter) Ihres Browsers angezeigt wird.',
    'NEW_LOGO' => 'Logo auswählen:',
    'NEW_LOGO_HELP' => 'Das Bildformat kann entweder .jpg oder .png sein. Die maximale Höhe ist 170px, die maximale Breite beträgt 450px. Ein größeres Bild wird auf eine dieser Dimensionen skaliert.',
    'COMPANY_LOGO_UPLOAD_BTN' => 'Hochladen',
    'CURRENT_LOGO' => 'Aktuelles Logo:',
    'CURRENT_LOGO_HELP' => 'Dieses Logo wird in der Mitte des Anmeldebildschirms der SuiteCRM Anwendung angezeigt.',


    //Scenario selection of modules
    'LBL_WIZARD_SCENARIO_TITLE' => 'Szenario-Auswahl',
    'LBL_WIZARD_SCENARIO_DESC' => 'Dies ermöglicht Ihnen die Anpassung der angezeigten Module, basierend auf ihren Anforderungen. Jedes der Module kann aktiviert werden, nachdem es auf der Verwaltungs Seite installiert wurde.',
    'LBL_WIZARD_SCENARIO_EMPTY' => 'Derzeit sind keine Szenarien in der Konfigurationsdatei (config.php) festgelegt',


    // System Local Settings


    'LBL_LOCALE_TITLE' => 'Lokale Systemeinstellungen',
    'LBL_WIZARD_LOCALE_DESC' => 'Basierend auf Ihrer geografischen Lage können Sie hier festlegen, wie Daten in SuiteCRM angezeigt werden sollen. Die hier festgelegten Einstellungen werden zum Standard, allerdings können sie von Benutzern individuell geändert werden.',
    'LBL_DATE_FORMAT' => 'Datumsformat:',
    'LBL_TIME_FORMAT' => 'Zeitformat:',
    'LBL_TIMEZONE' => 'Zeitzone:',
    'LBL_LANGUAGE' => 'Sprache:',
    'LBL_CURRENCY' => 'Währung:',
    'LBL_CURRENCY_SYMBOL' => 'Währungssymbol:',
    'LBL_CURRENCY_ISO4217' => 'ISO 4217 Währungscode',
    'LBL_NUMBER_GROUPING_SEP' => '1000er Trennzeichen:',
    'LBL_DECIMAL_SEP' => 'Dezimaltrennzeichen:',
    'LBL_NAME_FORMAT' => 'Namensformat:',
    'UPLOAD_LOGO' => 'Bitte warten, Logo wird hochgeladen...',
    'ERR_UPLOAD_FILETYPE' => 'Dateityp ist nicht erlaubt, bitte laden Sie jpeg oder png.',
    'ERR_LANG_UPLOAD_UNKNOWN' => 'Unbekannter Dateiupload Fehler ist aufgetreten.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_INI_SIZE' => 'Die hochgeladene Datei ist größer als upload_max_filesize in php.ini.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_FORM_SIZE' => 'Die hochgeladene Datei ist größer als die MAX_FILE_SIZE Richtlinie, die im HTML Fomular angegeben wurde.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_PARTIAL' => 'Die Datei wurde nur teilweise hochgeladen.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_NO_FILE' => 'Keine Datei hochgeladen.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_NO_TMP_DIR' => 'Ein temporäres Verzeichnis fehlt.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_CANT_WRITE' => 'Datei konnte nicht geschrieben werden.',
    'ERR_UPLOAD_FILE_UPLOAD_ERR_EXTENSION' => 'Eine PHP-Erweiterung hat den Dateiupload beendet. PHP bietet keinen Weg, um festzustellen, welche Erweiterung den Datei-Upload gestoppt hat.',

    'LBL_INSTALL_PROCESS' => 'Installieren...',

    'LBL_EMAIL_ADDRESS' => 'E-Mail Adresse:',
    'ERR_ADMIN_EMAIL' => 'Administrator E-Mail-Adresse ist nicht korrekt.',
    'ERR_SITE_URL' => 'Website-URL ist erforderlich.',

    'STAT_CONFIGURATION' => 'Beziehungen-Konfiguration...',
    'STAT_CREATE_DB' => 'Erstellen der Datenbank...',

    'STAT_CREATE_DEFAULT_SETTINGS' => 'Erstellen der Standardeinstellungen...',
    'STAT_INSTALL_FINISH' => 'Installieren beendet...',
    'STAT_INSTALL_FINISH_LOGIN' => 'Installationsprozess beendet, <a href="%s"> Bitte loggen Sie sich in...</a>',
    'LBL_LICENCE_TOOLTIP' => 'Bitte zuerst die Lizenz akzeptieren',

    'LBL_MORE_OPTIONS_TITLE' => 'Weitere Optionen',
    'LBL_START' => '',
    'LBL_DB_CONN_ERR' => 'Datenbank-Fehler',
    'LBL_OLD_PHP' => 'Alte PHP Version entdeckt!',
    'LBL_OLD_PHP_MSG' => 'Die empfohlene PHP-Version zur Installation von SuiteCRM ist %s <br />Die minimale PHP-Version ist %s<br />Sie verwenden die PHP-Version %s, welche EOL ist: <a href="http://php.net/eol.php">http://php. et/eol.php</a>.<br />Bitte erwägen Sie ein Upgrade Ihrer PHP-Version. ',
    'LBL_OLD_PHP_OK' => 'Ich bin mir der Risiken bewusst und möchte fortfahren.',

    'LBL_DBCONF_TITLE_USER_INFO_LABEL' => 'Benutzer',
    'LBL_DBCONFIG_MSG3_LABEL' => 'Datenbank Name',
    'LBL_DBCONFIG_MSG3' => 'Datenbankname für die SuiteCRM Instanz, die Sie gerade installieren:',
    'LBL_DBCONFIG_MSG2_LABEL' => 'Host Name',
    'LBL_DBCONFIG_MSG2' => 'Name von Web-Server oder Rechner (Host), auf dem sich die Datenbank (z. B. www.mydomain.com) befindet. Falls lokal installiert wird, ist es aus Performancegründen besser "Localhost" anstelle von "127.0.0.1" zu verwenden.',
    'LBL_DBCONFIG_B_MSG1_LABEL' => '', // this label dynamically needed in install/installConfig.php:293
    'LBL_DBCONFIG_B_MSG1' => 'Um die SuiteCRM Datenbank zu erstellen, ist der Benutzername und das Passwort eines Datenbankadministrators notwendig. Dieser muss die Datenbank, Tabellen und Benutzer erstellen können und muss Schreibrechte haben.',
    'LBL_SYS_CHECK_WARNING' => 'Warnungen zur Systemüberprüfung ignorieren',
    'LBL_PROCEED' => 'FORTSETZEN',
    'LBL_RECHECK' => 'RECHECK',
    'LBL_CONFIG' => 'KONFIGURATION',
    'LBL_VALIDATION_ERRORS' => 'Es gibt Validierungsfehler, die Aktion kann nicht ausgeführt werden.'
);
